// resource.cc for bbsload - an tool to display the load in X11.
// 
// Copyright (c) 1998-1999 John Kennis, j.m.b.m.kennis@tue.nl
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// (See the included file COPYING / GPL-2.0)
// 


#include <iostream>
#include "resource.hh"
#include "blackboxstyle.hh"


Resource::Resource(ToolWindow * toolwindow):
BaseResource(toolwindow)
{
    Load();
}


Resource::~Resource()
{
    Clean();
}

void
Resource::Clean()
{
    if (label.font)
	XFreeFont(bbtool->dpy, label.font);
    if (frame.font)
	XFreeFont(bbtool->dpy, frame.font);
    // if (menu.font)
    // XFreeFont(bbtool->dpy, menu.font);
}

void
Resource::LoadBBToolResource(void)
{
    XrmValue
	value;
    char           *
	value_type;

    if (XrmGetResource(resource_db, "bbapm.autoConfig",
		       "Bbapm.Autoconfig", &value_type, &value)) {
	if (!strncasecmp("true", value.addr, value.size))
	    style.auto_config = True;
	else
	    style.auto_config = False;
    } else {
	style.auto_config = False;
    }

#ifdef DEBUG
    cerr << "style.autoconfig = " << style.auto_config << endl;
#endif

    SizeAndPosition();

    Frame();

    Show();

#ifdef DEBUG
    cerr << "show.label = " << show.label << endl;
#endif

    if (show.label)
	Label();

//    if (show.label)
	LoadBar();

    CheckSettings();
}


void
Resource::Frame()
{
    XrmValue
	value;
    char           *
	value_type;

    readDatabaseTexture("bbapm.frame", "Bbapm.Frame", BB_FRAME, "Toolbar",
			"slategrey", "darkslategrey",
			BImage_Raised | BImage_Gradient | BImage_Vertical |
			BImage_Bevel1, &frame.texture);

    if (XrmGetResource(resource_db, "bbapm.bevelWidth",
		       "bbapm.BevelWidth", &value_type, &value)) {
	if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
	    frame.bevelWidth = 4;
	else if (frame.bevelWidth == 0)
	    frame.bevelWidth = 4;
    }
	else if (XrmGetResource(resource_db, BB_BEVELWIDTH,
				"TitleFont", &value_type, &value)) {
	if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
	    frame.bevelWidth = 4;
	else if (frame.bevelWidth == 0)
	    frame.bevelWidth = 4;
    } else
	frame.bevelWidth = 4;

}

void
Resource::SizeAndPosition()
{
    XrmValue
	value;
    char           *
	value_type;
    unsigned int
	w,
	h;
    char
	positionstring[11];

    if (!(bbtool->withdrawn)) {
	if (XrmGetResource(resource_db, "bbapm.withdrawn",
			   "Bbapm.Withdrawn", &value_type, &value)) {
	    if (!strncasecmp("true", value.addr, value.size))
		bbtool->withdrawn = True;
	    else
		bbtool->withdrawn = False;
	} else
	    bbtool->withdrawn = False;
    }

    if (!(bbtool->shape)) {
	if (XrmGetResource(resource_db, "bbapm.shape",
			   "Bbapm.Shape", &value_type, &value)) {
	    if (!strncasecmp("true", value.addr, value.size))
		bbtool->shape = True;
	    else
		bbtool->shape = False;
	} else
	    bbtool->shape = bbtool->withdrawn;
    }

    if (!(bbtool->position)) {
	if (!(XrmGetResource(resource_db, "bbapm.position",
			     "Bbapm.Position", &value_type, &value))) {
	    strncpy(positionstring, "-0-0", 5);
	} else {
	    strncpy(positionstring, value.addr, strlen(value.addr) + 1);
	}
    } else {
	strncpy(positionstring, bbtool->position, strlen(bbtool->position) + 1);
    }

    position.mask =
	XParseGeometry(positionstring, &position.x, &position.y, &w, &h);

    if (!(position.mask & XValue))
	position.x = 0;
    if (!(position.mask & YValue))
	position.y = 0;

    /*
     * need this to compute the height 
     */
    const char     *
	defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";

    if (frame.font) {
	XFreeFont(bbtool->dpy, frame.font);
	frame.font = 0;
    }

    if (XrmGetResource(resource_db, "bbapm.heightBy.font",
		       "bbapm.heightBy.Font", &value_type, &value)) {
	if ((frame.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL) {
	    fprintf(stderr, " blackbox: couldn't load font '%s'\n"
		    " ...  reverting to default font.", value.addr);
	    if ((frame.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL) {
		fprintf(stderr,
			"blackbox: couldn't load default font.  please check to\n"
			"make sure the necessary font is installed '%s'\n",
			defaultFont);
		exit(2);
	    }
	}
    }
	else if (XrmGetResource(resource_db, BB_FONT,
				"TitleFont", &value_type, &value)) {
	if ((frame.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL) {
	    fprintf(stderr, " blackbox: couldn't load font '%s'\n"
		    " ...  reverting to default font.", value.addr);
	    if ((frame.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL) {
		fprintf(stderr,
			"blackbox: couldn't load default font.  please check to\n"
			"make sure the necessary font is installed '%s'\n",
			defaultFont);
		exit(2);
	    }
	}
    } else {
	if ((frame.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL) {
	    fprintf(stderr,
		    "blackbox: couldn't load default font.  please check to\n"
		    "make sure the necessary font is installed '%s'\n",
		    defaultFont);
	    exit(2);
	}
    }
}

void
Resource::CheckSettings()
{
    XrmValue
	value;
    char           *
	value_type;

    if (XrmGetResource(resource_db, "bbapm.checkDelay",
		       "Bbapm.CheckDelay", &value_type, &value)) {
	if (sscanf(value.addr, "%lu", &report.check_delay) != 1)
	    report.check_delay = 5;
	else if (report.check_delay == 0)
	    report.check_delay = 5;
    } else
	report.check_delay = 5;

    if (XrmGetResource(resource_db, "bbapm.raised",
		       "Bbapm.Raised", &value_type, &value)) {
	if (!strncasecmp("true", value.addr, value.size))
	    bbtool->raised = True;
	else
	    bbtool->raised = False;
    } else
	bbtool->raised = True;
}


void
Resource::Label(void)
{
    XrmValue
	value;
    char           *
	value_type;

    /*
     * text-label resources 
     */
    if (XrmGetResource(resource_db, "bbapm.label.transparent",
		       "Bbapm.label.Transparent", &value_type, &value)) {
	if (!strncasecmp("true", value.addr, value.size))
	    label.transparent = True;
	else
	    label.transparent = False;
    } else
	label.transparent = False;

    readDatabaseTexture("bbapm.label", "Bbapm.Label",
			BB_LABEL, "Toolbar.Label",
			"slategrey", "darkslategrey",
			BImage_Sunken | BImage_Gradient | BImage_Vertical |
			BImage_Bevel1, &label.texture);

    if (show.label_percentage) {
	readDatabaseColor("bbapm.percentage.label.textColor",
			  "Bbapm.Percentage.Label.TextColor",
			  BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
			  "LightGrey", &label.percentage_textColor);
    }

    if (show.label_time) {
	readDatabaseColor("bbapm.time.label.textColor",
			  "Bbapm.Time.Label.TextColor",
			  BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
			  "LightGrey", &label.time_textColor);
    }

    readDatabaseColor("bbapm.seperator.textColor",
		      "Bbapm.Seperator.TextColor",
		      BB_LABEL_TEXTCOLOR, "Toolbar.TextColor",
		      "LightGrey", &label.seperator_textColor);

    const char     *
	defaultFont = "-*-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*";

    if (label.font) {
	XFreeFont(bbtool->dpy, label.font);
	label.font = 0;
    }

    if (XrmGetResource(resource_db, "bbapm.label.font",
		       "Bbapm.Label.Font", &value_type, &value)) {
	if ((label.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL) {
	    fprintf(stderr, " blackbox: couldn't load font '%s'\n"
		    " ...  reverting to default font.", value.addr);
	    if ((label.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL) {
		fprintf(stderr,
			"blackbox: couldn't load default font.  please check to\n"
			"make sure the necessary font is installed '%s'\n",
			defaultFont);
		exit(2);
	    }
	}
    }
	else if (XrmGetResource(resource_db, BB_FONT,
				"TitleFont", &value_type, &value)) {
	if ((label.font = XLoadQueryFont(bbtool->dpy, value.addr)) == NULL) {
	    fprintf(stderr, " blackbox: couldn't load font '%s'\n"
		    " ...  reverting to default font.", value.addr);
	    if ((label.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL) {
		fprintf(stderr,
			"blackbox: couldn't load default font.  please check to\n"
			"make sure the necessary font is installed '%s'\n",
			defaultFont);
		exit(2);
	    }
	}
    } else {
	if ((label.font = XLoadQueryFont(bbtool->dpy, defaultFont)) == NULL) {
	    fprintf(stderr,
		    "blackbox: couldn't load default font.  please check to\n"
		    "make sure the necessary font is installed '%s'\n",
		    defaultFont);
	    exit(2);
	}
    }
}


void
Resource::Show()
{
    XrmValue
	value;
    char           *
	value_type;

    show.label = False;
    /*
     * what to show.resources 
     */
    if (XrmGetResource(resource_db, "bbapm.show.percentage.label",
		       "Bbapm.Show.Percentage.Label", &value_type, &value)) {
	if (!strncasecmp("true", value.addr, value.size)) {
	    show.label_percentage = True;
	    show.label = True;
	} else
	    show.label_percentage = False;
    } else
	show.label_percentage = False;

    if (XrmGetResource(resource_db, "bbapm.show.percentage.loadbar",
		       "Bbapm.Show.Percentage.Loadbar", &value_type, &value)) {
	if (!strncasecmp("true", value.addr, value.size)) {
	    show.percentage = True;
	} else
	    show.percentage = False;
    } else
	show.percentage = False;

    if (XrmGetResource(resource_db, "bbapm.show.loading",
		       "Bbapm.Show.Loading", &value_type, &value)) {
	if (!strncasecmp("true", value.addr, value.size)) {
	    show.loading = True;
	    show.label = True;
	} else
	    show.loading = False;
    } else
	show.loading = False;

    if (XrmGetResource(resource_db, "bbapm.show.loading.time",
		       "Bbapm.Show.Loading.Time", &value_type, &value)) {
	if (sscanf(value.addr, "%u", &show.loadingTime) != 1) {
	    show.loadingTime = 1;
	} else
	    show.loadingTime = 1;
    } else
	show.loadingTime = 1;

    if (XrmGetResource(resource_db, "bbapm.show.time.label",
		       "Bbapm.Show.Time.label", &value_type, &value)) {
	if (!strncasecmp("true", value.addr, value.size)) {
	    show.label_time = True;
	    show.label = True;
	} else
	    show.label_time = False;
    } else
	show.label_time = False;
#ifdef DEBUG
    cerr << "Resource::Show() result: "<<endl;
    cerr << "\tshow.label = " << show.label << endl;
    cerr << "\tshow.percentage = " << show.percentage << endl;
    cerr << "\tshow.loading = " << show.loading << endl;
    cerr << "\tshow.label_time = " << show.label_time << endl;
    cerr << "\tshow.label_percentage = " << show.label_percentage << endl;
#endif
}


void
Resource::LoadBar()
{
    XrmValue
	value;
    char           *
	value_type;
    unsigned long
	texture;

    texture = BImage_Vertical | BImage_Gradient | BImage_Flat | BImage_Bevel2;

    readDatabaseTexture("bbapm.loadbar.active", "Bbapm.Loadbar.Active",
			BB_BUTTON_PRESSED, "Toolbar.Button.Pressed",
			"red1", "green", texture, &loadbar.active_texture);

    texture = BImage_Solid | BImage_Flat | BImage_Bevel2;

    readDatabaseTexture("bbapm.loadbar.inactive", "Bbapm.Loadbar.Inactive",
			BB_BUTTON, "Toolbar.Button",
			"black", "black", texture, &loadbar.inactive_texture);

    if (XrmGetResource(resource_db, "bbapm.loadbar.width",
		       "Bbapm.Loadbar.Bottom.Width", &value_type, &value)) {
	if (sscanf(value.addr, "%u", &loadbar.width) != 1)
	    loadbar.width = 30;
    } else
	loadbar.width = 30;

    if (XrmGetResource(resource_db, "bbapm.loadbar.left.stepWidth",
		       "Bbapm.Loadbar.Left.StepWidth", &value_type, &value)) {
	if (sscanf(value.addr, "%u", &loadbar.left_step_width) != 1)
	    loadbar.left_step_width = 2;
    } else
	loadbar.left_step_width = 2;

    if (XrmGetResource(resource_db, "bbapm.loadbar.right.stepWidth",
		       "Bbapm.Loadbar.Right.StepWidth", &value_type, &value)) {
	if (sscanf(value.addr, "%u", &loadbar.right_step_width) != 1)
	    loadbar.right_step_width = 2;
    } else
	loadbar.right_step_width = 2;

    if (XrmGetResource(resource_db, "bbapm.loadbar.numberOf.bars",
		       "Bbapm.Loadbar.NumberOf.Bars", &value_type, &value)) {
	if (sscanf(value.addr, "%u", &loadbar.number_of_bars) != 1)
	    loadbar.number_of_bars = 6;
    } else
	loadbar.number_of_bars = 6;

    if (XrmGetResource(resource_db, "bbapm.loadbar.ratio",
		       "Bbapm.Loadbar.Ratio", &value_type, &value)) {
	int
	    ratio;
	if (sscanf(value.addr, "%u", &ratio) != 1)
	    loadbar.ratio = 0.5;
	else
	    loadbar.ratio = ratio / 100.0;
    } else
	loadbar.ratio = 0.5;

    if (XrmGetResource(resource_db, "bbapm.loadbar.maximum.precentage",
		       "Bbapm.Loadbar.Maximum.Precentage", &value_type, &value)) {
	if (sscanf(value.addr, "%le", &loadbar.max_time) != 1)
	    loadbar.max_time = 100.0;
    } else
	loadbar.max_time = 100.0;
}
