// resource.hh for bbsload - an tool to display new mail in X11.
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "bbapm.hh"
#include "Baseresource.hh"

class BaseResource;

struct FRAME {
    int width;
    int height;
    BTexture texture;
    int bevelWidth;
    XFontStruct *font;
};

struct POSITION {
    int x;
    int y;
    int mask;
};

struct LABEL {
    int width;
    int width0, width1, width2, width3;
    int height;
    BTexture texture;
    bool transparent;
    XFontStruct *font;
    BColor percentage_textColor;
    BColor time_textColor;
    BColor seperator_textColor;
};

struct LOADBAR {
    int width;
    BTexture active_texture;
    BTexture inactive_texture;
    int left_step_width;
    int right_step_width;
    double ratio;
    int number_of_bars;
    double max_time;		// 100% obviously.
};

struct SHOW {
    bool label;
    bool percentage;		// Display percentage loadbar
    bool loading;		// Display the loading indicator
    int loadingTime;		// At what interval the loadbar should be
				// updated if the battery is loading
    bool label_time;		// Display the time left.
    bool label_percentage;	// Percentage shown in text
};

struct REPORT {
    time_t check_delay;
};

class Resource : public BaseResource
{

public:
    Resource::Resource(ToolWindow *);
    Resource::~Resource(void);

    struct FRAME frame;
    struct LABEL label;
    struct POSITION position;
    struct LOADBAR loadbar;
    struct SHOW show;
    struct REPORT report;

 protected:
  	virtual void  LoadBBToolResource(void);

private:
    void Frame(void);
    void SizeAndPosition(void);
    void CheckSettings(void);
    void Label(void);
    void Show(void);
    void LoadBar(void);
    void Clean(void);
};
#endif /* __RESOURCE_HH */
