/* $Id: sid.h,v 1.5 2003/05/03 02:45:22 andrewbaker Exp $ */
/*
** Copyright (C) 2001-2002 Andrew R. Baker <andrewb@snort.org> 
** Copyright (C) 2001 Martin Roesch <roesch@sourcefire.com>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/
 

#ifndef __SID_H__
#define __SID_H__

#include <stdio.h>
#include "config.h"

#define BUGTRAQ_URL_HEAD   "http://www.securityfocus.com/bid/"
#define CVE_URL_HEAD       "http://cve.mitre.org/cgi-bin/cvename.cgi?name="
#define ARACHNIDS_URL_HEAD "http://www.whitehats.com/info/IDS"
#define MCAFEE_URL_HEAD    "http://vil.nai.com/vil/content/v_"
#define URL_HEAD           "http://"
#define NESSUS_URL_HEAD	   "http://cgi.nessus.org/plugins/dump.php3?id="

#define SID_BUFFER_SIZE  1024

typedef struct _ReferenceData
{
  char *system;
  char *id;
  char *url;
  struct _ReferenceData *next;

} ReferenceData;


typedef struct _Sid
{
    u_int32_t gen;         /* generator ID */
    u_int32_t sid;         /* Snort ID */
    u_int32_t rev;         /* revision (for future expansion) */
    char *msg;             /* message for this ID */
    char *CSVmsg;          /* CSV escaped message */
        
    ReferenceData *ref;

    struct _Sid *next;
} Sid;


void InitSidMap(char *);
void InitGenData(char *);
void FreeSidMap();
Sid *GetSid(u_int32_t, u_int32_t);
void PrintXref(int, int, FILE *);
Sid *FakeSid(u_int32_t, u_int32_t);

#endif  /* __SID_H__ */
