/*
   global types used by the BACI interpreter

*/


#define  UNDEF_VALUE 0x3f3f   /* '??' as char, val of undef vbl */
#define  STEPMAX     4        /* max steps before process switch */
#define  STEPMAXP1   5

#define  STMAX    6000        /* size of stack */
#define  STKINCR  200         /* stack size for each process */

#define  MAXPRIO  0x7FFF      /* max priority a WAITC can have */

enum  pstat{   run,           /* normal operation */
               fin,           /* normal termination */
               divchk,        /* division error */
               inxchk,        /* array indexing error */
               stkchk,        /* stack addressing error */
               charchk,       /* invalid character */
               inpchk,        /* invalid input type */
               pcodchk,       /* invalid PCODE opcode */
               rdchk,         /* read error */
               wrtchk,        /* write error */
               padrchk,       /* invalid PCODE address */
               semchk,        /* invalid value in a general semaphore */
               bsemchk,       /* invalid value in a binary semaphore */
               uisemchk,      /* unititialized semaphore */
               xmonchk,       /* cross-monitor call */
               redchk,        /* attempt to read past EOF */
               procchk,       /* invalid process ID */
               deadlock       /* no runnable process */
         };

/* process table type -- information kept for each concurrent process */
typedef struct   {  
            unsigned    pc;         /* program counter */
            unsigned    t,b;        /* top, bottom of AR */
            int         tabix;      /* index into tab array */
            int         stacksize;  /* stack limit */
            int         display[LSIZE];   /* display */
            int         suspend;    /* -1 or stack addr of semaphore */
            int         active;     /* process active? */
            int         monitor;    /* 0 or tab index of monitor */
            int         priority;   /* WAITC priority P&W */
            int         atomic;     /* is process un-interruptable? */
            unsigned    xpc;        /* no. of pcode instrs executed */
   } proctab;


/*
 * $Log: bainterp.h,v $
 * Revision 1.2  1997/12/16 19:43:16  bynum
 * rename MAXINT to MAXPRIO and reduce the value to 0x7FFF
 *
 * Revision 1.1  1997/07/02 13:33:34  bynum
 * Initial revision
 *
 */
