   /* 
      BACI disassembly utilities
      used by the disassembler and interpreter
   */

extern CODEBLOCK cbtab[];
   /* code block table, used to mark proc boundaries */

extern int last_cbtab;
   /* size of the code block table */

extern int build_cbtab();
   /* Build the code block table   */

extern int search_var(int tabix, int level, int offset);
   /* search for a variable at 'level' & 'offset' starting at the */
   /* proc whose tab[] index is 'tabix'.  Continue the search     */
   /* outward through every block in the code block table at a    */
   /* lower level than the tab[tabix] proc                        */
   /* return the tab[] index of the variable, if found, else 0    */
   /* When 'level' == 0, this is the return value of a function.  */
   /* In this case, return the tabix of the function              */

extern void disassemble(char *dis_line, int tix, int lc);
   /* disassemble the instruction at code[lc] into the buffer 'dis_line */
   /* 'tix' is the tab index of the current block                       */
   /* used by search_var for searching the symbol table                 */


/*
 * $Log: disutils.h,v $
 * Revision 1.3  1998/07/05 22:41:28  bynum
 * change prototype of disassemble from output to a FILE* to output to char*
 *
 * Revision 1.2  1997/09/04 10:59:44  bynum
 * change cbtab_size to last_cbtab
 *
 * Revision 1.1  1997/07/02  14:06:48  bynum
 * Initial revision
 *
 */
