/* constants & types for the BenAri Concurrent Pascal PCODE Interpreter */


#ifndef __CONST_TYPES__
#define __CONST_TYPES__ 1

#include <stdio.h>

#define  TRUE  1
#define  FALSE 0
#define  MAX_FNAME   256
#define  SUFFIX_LEN  4
#define  MAX_PREFIX  251      /* MAX_FNAME - SUFFIX_LEN */
#define  LMAX  7     /* max level index */
#define  LSIZE 8     /* display array size */
#define  TMAX  500   /* max tab index */
#define  TSIZE 501   /* tab array size */
#define  BMAX  50    /* max btab index */
#define  BSIZE 51    /* btab array size */
#define  AMAX  50    /* max atab index */
#define  ASIZE 51    /* atab array size */
#define  CMAX  2000  /* max code index */
#define  CSIZE 2001  /* code array size */
#define  SMAX  900   /* max stab index */
#define  SSIZE 901   /* stab array size */
#define  ALNG  12    /* number of significant chars in an id */
#define  ALNGSIZE 13 /* allow for null terminator */
#define  GULPSIZE 60 /* # chars per line in storing stab array */

#define  PMAX     18    /* no. of concurrent processes */
#define  PMAXP1   19    /* should be a prime */

#define MAXMON 20    /* largest mtab array index */
#define MONSIZE 21   /* max number of monitors definable */

#define  LINESIZE  120
#define  MAXLINE   119

#define  BUFSIZE  120
typedef  char  BUFFER[BUFSIZE];  

#define  MAXERROR 4

#define  DEFAULT_PRIO   10    /* default priority in WAITC call */

typedef  char PREFIX_STRING[MAX_PREFIX];
typedef  char FNAME_STRING[MAX_FNAME];
typedef  char ALFA[ALNGSIZE];
typedef  char TYPENAME[6];
typedef  char OBJNAME[10];

typedef enum { constant, variable, type, procedure, 
               function, monitor, mainproc,outerblock,
               ext_procedure, ext_function, ext_monitor,
               ext_variable }  OBJTYPE;

typedef enum { notyp = 0, ints = 1, bools = 2, chars = 3, bsems = 4, 
               sems = 5, conds = 6, arrays = 7, 
               rawstrings  = 10 /* "xxx" */, 
               strings = 11/* string vbl */  }  TYPES;

typedef struct { int f; int x; int y; } ORDER;   /* pcode type */

typedef struct {
   int   lc;      /* value of lc where source file line no changed */
   int   fix;     /* index of the file generating this pcode instr */
   int   flno;    /* line # in the that should be showing for this instr */
}PCDEBUG;         /* debugging information about the pcode */

/* used for include files */
typedef struct{
      char  *fname;           /* name of the include file  */
      int   last_line_no;     /* last line no in it that genned pcode */
      int   line_no;          /* current line number in it */
      int   parent;           /* index in 'infile' array of parent file */
      void* flexbuf;          /* ptr to flex buffer */
      FILE *f;                /* stream for this file */
} InputFile;

/* symbol table structure */
typedef struct {  ALFA     name;    /* symbol name */
                  int      link;    /* tab index of next symbol this level */ 
                  OBJTYPE  obj;     /* sort of object this is */
                  TYPES    typ;     /* type of this object */
                  int      ref;     /* btab index(proc); atab index(array) */
                  int      normal;  /* FALSE for VAR parms, TRUE all else */
                  int      lev;     /* level of this symbol */
                  int      adr;     /* entry pt(proc),size(type),value(vbl)*/
                  int      mon;     /* tab index of monitor (monproc), else 0*/
                  int      atomic;  /* TRUE if proc or func is atomic */
      } TAB_STRUCT;                 

/* array table.  EACH DIMENSION of an array takes 1 entry */
typedef struct {  TYPES    inxtyp;  /* index type for this dimension */
                  TYPES    eltyp;   /* elem type, (arrays if more dims left)*/
                  int      elref;   /* atab index (if arrays) 0 if not */
                  int      low;     /* smallest index this dimension */
                  int      high;    /* largest index this dimension */ 
                  int      elsize;  /* element size */
                  int      size;    /* size of the entire array */
      } ATAB_STRUCT;

typedef struct {  int      last;    /* tab index, last id in this block */
                  int      lastpar; /*  ", last parameter this block */
                  int      psize;   /* stackframe size = 5 (fixed) + parms */
                  int      vsize;   /* psize + size of local variables */
      } BTAB_STRUCT;


/* expressions in the compiler */
typedef struct{
                  OBJTYPE  obj;     /* values transferred from tab entry */
                  TYPES    typ;     /* of object, if it's in the symbol  */
                  int      adr;     /* table                             */
                  int      ref;    
                  int      lev;
                  int      normal;
                  int      tix;     /* tab index, if a var ident */
                  int      arelt; 
                  int      isval; 
                  int      free;  
               } EXPR;
               
#define  EXPRSIZE 64
#define  MAXEXPR  63

   /* struct for the code block table              */
   /* used by the disassembler and interpreter     */
typedef struct {
   int   tix;     /* index into tab array of this code block */
   int   bix;     /* index into btab array of this code block */
   int   adr;     /* lc of first byte of code for the code block */
      } CODEBLOCK;


#endif

/*
 *  $Log: bacicnty.h,v $
 *  Revision 1.11  1998/07/05 22:43:14  bynum
 *  add last_line_no to the InputFile struct
 *
 *  Revision 1.10  1997/12/16 19:49:35  bynum
 *  reduce MAXERROR from 10 to 4
 *
 *  Revision 1.9  1997/07/02 14:05:44  bynum
 *  add extern OBJTYPES, CODEBLOCK type
 *
 * Revision 1.8  1997/06/17  05:47:08  bynum
 * add mainproc OBJTYPE, add initializers in TYPES enum, remove dbints,
 * dbchars from TYPES enum
 *
 * Revision 1.7  1997/02/04  08:17:38  bynum
 * switch to FLEX
 *
 * Revision 1.6  1996/03/07  09:14:15  bynum
 * add commenting
 *
 * Revision 1.5  1995/09/07  14:17:35  bynum
 * moved in compiler types & constants, removed __DEFINING__ constant
 *
 * Revision 1.4  1995/09/05  14:50:12  bynum
 * up stack size, add PCDEBUG struct
 *
 * Revision 1.3  1995/07/06  14:07:13  bynum
 * enlarge tab, btab, and atab sizes
 *
 * Revision 1.2  1995/06/30  13:51:03  bynum
 * moved PMAX and PMAXP1 from interpreter here
 *
 * Revision 1.1  1995/06/19  17:05:47  bynum
 * Initial revision
 *
 *
 */
