 /* BenAri Concurrent PCODE disassembler  main program */
 /*   
   disassembles a PCODE file, showing source lines, if possible 
   Bill Bynum
   June 1997
 */

#include <stdio.h>
#include <string.h>

#include "../include/globdata.h"
#include "../include/disutils.h"

char dis_line[256];

extern int fprintf(FILE*,const char*,...);
extern int fputs(const char*, FILE*);
extern int fclose(FILE*);

extern FNAME_STRING prog_name;

extern FNAME_STRING   disasm_fname;
extern FILE*          disasm;

extern int source_wanted;

extern void global_init(int argc, char** argv);

extern void show_source(FILE*, int,int*,int*,int*);

extern void disassemble(char *dis_line, int tix, int lc);

int main(int argc, char* argv[])
{
   int nextblock_lc = 0;
   int cur_block = -1;
   int cur_ifile = 0;
   int dbix = 0;
   int showing_source;

   global_init(argc,argv);
   showing_source = source_wanted;
   while  (lc <= last_code) {
      if (showing_source &&(dbg[dbix].lc <= lc))
         show_source(disasm,lc,&cur_ifile,&showing_source,&dbix);
      if (lc >= nextblock_lc) {
         cur_block++;
         if (cur_block == last_cbtab)
            nextblock_lc = last_code+1;
         else
            nextblock_lc = cbtab[cur_block + 1].adr;
         if ((!source_wanted)||(!showing_source)||
             (tab[cbtab[cur_block].tix].obj == outerblock))
            fprintf(disasm,"\n%s:\n",tab[cbtab[cur_block].tix].name);
      }
      disassemble(dis_line,cbtab[cur_block].tix,lc);
      fputs(dis_line,disasm);
      lc++;
   }
   fclose(disasm);
   fprintf(stderr,"Disassembly stored in %s\n",disasm_fname);
   return 0;
}  /* main */

/*
 *  $Log: main.c,v $
 *  Revision 1.6  1998/07/05 22:46:56  bynum
 *  change disassemble prototype decl, add fputs call
 *
 * Revision 1.5  1997/10/24  09:38:43  bynum
 * change extern declaration to satisfy gcc -Wall
 *
 *  Revision 1.4  1997/10/18 18:55:00  bynum
 *  switch to last_code from code_size and last_cbtab from cbtab_size
 *
 * Revision 1.3  1997/07/02  13:49:57  bynum
 * add global_init() extern declaration, add outerblock test for showing
 * the block label
 *
 * Revision 1.2  1997/06/20  10:11:34  bynum
 * change test from 'source_wanted' to 'showing_source'
 *
 * Revision 1.1  1997/06/09  12:44:34  bynum
 * Initial revision
 *
 */
