#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

int gettoken(char *token)
{
int ptr=0,tokentype=TOK_KEYWORD;
int ch,sflag=0,r=0;
int quote=0;

  if (tokenpush2[0]!=0)
  {
    strcpy(token,tokenpush2);
    tokenpush2[0]=0;
    return tokentypepush2;
  }

  if (tokenpush[0]!=0)
  {
    strcpy(token,tokenpush);
    tokenpush[0]=0;
    return tokentypepush;
  }

  token[1]=0;

  while(1)
  {
    if (pushback!=-1)
    { ch=pushback; pushback=-1; }
      else
    { ch=getc(in); }

    column++;

    if (ch==EOF) break;

    if (quote=='\'' && sflag!=1)
    {
      if (ch=='\n' || ch=='\r')
      { 
        token[0]='/';
        for (r=ptr; r>0; r--)
        { token[r]=token[r-1]; }
        //token[ptr+1]='\n';
        token[ptr+1]=0;
        return TOK_COMMENT;
      }
        else
      if (ch=='%')
      {
        ch=getc(in);

        if (ch=='>')
        {
          push("%>",6);
          token[0]='/';
          for (r=ptr; r>0; r--)
          { token[r]=token[r-1]; }
          token[ptr+1]=' ';
          token[ptr+2]=0;
          return TOK_COMMENT;
        }
          else
        {
          pushback=ch;
        }
      }
    }

    if (sflag==1)
    {
      if (ch!=quote)
      {
        pushback=ch;
        token[ptr]=0;
/*        fixw2k(token); */
        if (ch=='\'') return TOK_SNGQT; else return TOK_DBLQT;
      }

      sflag=0;
    }

    if (ch=='\"' || ch=='\'')
    {
      if (ptr==0)
      { quote=ch; }
        else
      if (quote==ch && (ch=='\"' || language==1))
      {
        if (token[ptr-1]==ch && sflag!=3)
        {
          if (ptr==1)
          {
            ch=getc(in);
            pushback=ch;
            if (ch!=quote)
            {
              token[ptr]=quote;
              token[ptr+1]=0;
              if (quote=='\'') return TOK_SNGQT; else return TOK_DBLQT;
            }
            sflag=1;
          }
            else
          if (sflag!=3)
          {
            token[ptr-1]='\\';
            sflag=3;
            token[ptr++]=ch;
            continue;
          }
        }
          else
        { sflag=1; }
      }
    }

    if (sflag==3) sflag=0;

    if (quote!=0)
    {
      token[ptr++]=ch;
      if (ch=='\\') token[ptr++]=ch;  /* double up a backslash */
      continue;
    }

    if ((ch=='>' && ptr==1) && token[ptr-1]=='%')
    { token[1]='>'; token[2]=0; return TOK_ENDCODE; }

    if (sflag==2)
    {
      if (ch=='=' || (ch=='>' && token[0]=='<'))
      { token[1]=ch; token[2]=0; }
        else
      { pushback=ch; token[1]=0; }
      return TOK_RELOP;
    }

    if (ch=='>' || ch=='<')
    {
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }
        else
      { sflag=2; tokentype=TOK_RELOP; }
    }

    if (ch=='(' || ch==')')
    { 
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }
        else
      { token[0]=ch; return TOK_PAREN; }
    }

    if (ch=='%')
    {
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }
    }

    if (ch=='=')
    {
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }
        else
      { token[0]=ch; return TOK_RELOP; }
    }

    if (ch=='&')
    {
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }

      token[0]=ch;

      if (pushback!=-1)
      { ch=pushback; pushback=-1; }
        else
      { ch=getc(in); }

      if (tolower(ch)=='h')
      { 
        token[ptr++]='0';
        token[ptr++]='x';
        tokentype=TOK_NUMBER;
        continue;
      }
        else
      {
        pushback=ch;
        token[1]=0;
        return TOK_AMP;
      }

/*
      if (ptr!=0)
      {
  if (ptr==1 && (ch=='h' || ch=='H'))
        {
    token[0]='0';
    token[1]='x';
    tokentype=TOK_NUMBER;
        }
    else
  { pushback=ch; token[ptr]=0; break; }
      }
  else
      { token[0]=ch; return TOK_AMP; }
*/
    }

    if (ch==':')
    {
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }
  else
      { token[0]=ch; return TOK_COLON; }
    }

    if (ch==',')
    {
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }
  else
      { token[0]=ch; return TOK_COMMA; }
    }

    if (ch=='.')
    {
      if (ptr!=0)
      { pushback=ch; token[ptr]=0; break; }
  else
      { token[0]=ch; return TOK_PERIOD; }
    }

    if ((ch=='+' || ch=='-') || (ch=='*' || ch=='/'))
    {
      if (ptr==0)
      { token[0]=ch; token[1]=0; return TOK_ARITHOP; }
  else
      {
  pushback=ch;
        break;
      }
    }

    if (ch=='_')
    {
      if (ptr==0)
      {
  token[0]=ch;
  while ((ch=getc(in))!=EOF)
        {
    if (ch=='\n' || ch=='\r')
          {
            line++;
      r=getc(in);
            if (r=='\r' || r=='\n')
            { if (ch==r) pushback=r; }
        else
      { pushback=r; }
      return TOK_UNDERSCORE;
    }
        }
        return TOK_EOF;
      }
  else
      if (tokentype==TOK_KEYWORD)
      { token[ptr++]=ch; continue; }
  else
      { pushback=ch; break; }
    }

    if (ch=='\r' || ch=='\n')
    {
      if (ptr==0)
      {
        token[0]='\n';
        column=0;
        line++;
  r=getc(in);
        if (r=='\r' || r=='\n')
        { if (ch==r) pushback=r; }
    else
  { pushback=r; }
        return TOK_EOL;
      }
  else
      { pushback=ch; break; }
    }

    if (ch==' ' || ch=='\t')
    {
      if (ptr==0)
      { /* putc(ch,out); */ continue; }
  else
      {
        pushback=ch;
        token[ptr]=0;
        return tokentype;
      }
    }

    if (tokentype==TOK_NUMBER)
    {
      if (ch<'0' || ch>'9')
      { pushback=ch; break; }
    }

    if (ch>='0' && ch<='9')
    {
      if (ptr==0)
      { tokentype=TOK_NUMBER; }
    }

    token[ptr++]=(char)ch;
  }

  if (ptr==0) return TOK_EOF;

  token[ptr]=0;
  return tokentype;
}

