/*
 * Copyright 2013-2019 Arx Libertatis Team (see the AUTHORS file)
 *
 * This file is part of Arx Libertatis.
 *
 * Original source is copyright 2010 - 2011. Alexey Tsoy.
 * http://sourceforge.net/projects/interpreter11/
 *
 * Boost Software License - Version 1.0 - August 17th, 2003
 *
 * Permission is hereby granted, free of charge, to any person or organization
 * obtaining a copy of the software and accompanying documentation covered by
 * this license (the "Software") to use, reproduce, display, distribute,
 * execute, and transmit the Software, and to prepare derivative works of the
 * Software, and to permit third-parties to whom the Software is furnished to
 * do so, all subject to the following:
 *
 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer,
 * must be included in all copies of the Software, in whole or in part, and
 * all derivative works of the Software, unless such copies or derivative
 * works are solely in the form of machine-executable object code generated by
 * a source language processor.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef ARX_UTIL_CMDLINE_ELLIPSIS_H
#define ARX_UTIL_CMDLINE_ELLIPSIS_H

#include <vector>

namespace util { namespace cmdline {

/*!
 * This class is a kind of sequence container.
 *
 * You can use this class just likes as std::vector.
 * It is used to indicate option with variable amount of parameters.
 *
 * \param T Type of the elements.
 *
 * \param Alloc Type of the allocator object used to define the storage
 * allocation model. By default, the allocator class template for type T
 * is equal to the default allocator class for std::vector<T>
 */
template <typename T, typename Alloc = typename std::vector<T>::allocator_type>
class ellipsis : std::vector<T, Alloc> {
	
	typedef std::vector<T> super_t;
	
public:
	
	typedef typename super_t::allocator_type allocator_type;
	typedef typename super_t::size_type size_type;
	typedef typename super_t::difference_type difference_type;
	typedef typename super_t::pointer pointer;
	typedef typename super_t::const_pointer const_pointer;
	typedef typename super_t::reference reference;
	typedef typename super_t::const_reference const_reference;
	typedef typename super_t::value_type value_type;
	typedef typename super_t::iterator iterator;
	typedef typename super_t::const_iterator const_iterator;
	typedef typename super_t::reverse_iterator reverse_iterator;
	typedef typename super_t::const_reverse_iterator const_reverse_iterator;
	
	using super_t::reserve;
	using super_t::capacity;
	using super_t::begin;
	using super_t::end;
	using super_t::rbegin;
	using super_t::rend;
	using super_t::resize;
	using super_t::size;
	using super_t::max_size;
	using super_t::empty;
	
	using super_t::at;
	using super_t::operator[];
	using super_t::front;
	using super_t::back;
	using super_t::push_back;
	using super_t::pop_back;
	
	using super_t::assign;
	using super_t::insert;
	using super_t::erase;
	using super_t::clear;
	using super_t::get_allocator;
	
	explicit ellipsis(const allocator_type & a = allocator_type()) : super_t(a) {
	}
	
	explicit ellipsis(size_type s, const value_type & v = value_type(),
	                  const allocator_type & a = allocator_type())
		: super_t(s, v, a) {
	}
	
	template <typename Iter>
	ellipsis(Iter b, Iter e, const allocator_type & a = allocator_type())
		: super_t(b, e, a) {
	}
	
	ellipsis(const ellipsis & rh) : super_t(rh) { }
	
	ellipsis & operator=(const ellipsis & rh) {
		static_cast<super_t &>(*this) = rh;
		return *this;
	}
	
	void swap(ellipsis & rh) {
		super_t::swap(rh);
	}
	
};

} } // namespace util::cmdline

#endif // ARX_UTIL_CMDLINE_ELLIPSIS_H
