
Contributions of all kinds are welcome as [GitHub pull requests](https://github.com/arx/ArxLibertatis/pulls) or [bug reports](https://bugs.arx-libertatis.org/).

The main communication channel for Arx Libertatis development is the [#arxfatalis IRC channel on freenode.net](https://wiki.arx-libertatis.org/IRC_channel). If you don't have an IRC client, you can use the [web chat](https://webchat.freenode.net/#arxfatalis).

If you are planning to fix a tricky bug or implement a larger feature and intend to get it merged, please [contact us](https://arx-libertatis.org/contact) **first** via IRC or on the [bug tracker](https://bugs.arx-libertatis.org/) to discuss and coordinate the planned changes in order to avoid duplicating work or having to re-do the changes in a way that fits with the project.

All new code must follow the [code style guide](https://wiki.arx-libertatis.org/Code_Style_Guide), including git commit messages. If anything is unclear try to match the style of the existing (updated) code or ask us to update the guide.

Please do not introduce any new compiler errors or warnings. It is *not* expected of contributors to test with [all supported compilers and static analysis tools](https://arx-libertatis.org/buildlogs/arx/branches/master/) but please make sure your changes compile without warnings on the compiler you use for development. `make style` should also report zero warnings.

All source code must be licensed under the "GPLv3 or newer" license detailed in the COPYING and LICENSE files. Non-code contributions should be licensed under appropriate free software or copyleft licenses. Do not submit any code or resources which you do not have the rights to, such as scripts or other assets from Arx Fatalis that were not included in the open-source release of the game.

If you are looking for something to contribute, check the [requested features](https://bugs.arx-libertatis.org/arx/issues/find/saved_search/2/search/1) and [open issues](https://bugs.arx-libertatis.org/arx/issues/find/saved_search/3/search/1) on the bug tracker.

Also check the [developer resources on the wiki](https://wiki.arx-libertatis.org/Developer_Information). For any other questions don't hesitate to [contact us](https://arx-libertatis.org/contact). 
