/*
 *      file.c from Access Point SNMP Utils for Linux
 * file accessing functions
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <sys/wait.h>
#include <ncurses.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "ap-utils.h"

extern WINDOW *main_sub, *win_for_help, *main_win;
extern char *ap_types[];

#define MAX_LINES LINES-6

struct APList {
       char *ip;
       char *passwd;
       int  type;
       struct APList * next;
};

void
_scroll_rows(struct APList *first, int begin, int end)
{
    int i = 1;
    struct APList *curr = first;
    char message[50];

    clear_main(3);

    while (i++ < begin)
        curr = curr->next;
        i = 0;
    while (end-- > begin) {
         sprintf(message, "%5u  %15s  %s", begin + i, curr->ip, ap_types[curr->type]);
	mvwaddstr(main_sub, 2 + i, 1, message);
    	i++;
    	curr = curr->next;
    }
    wrefresh(main_sub);
}

struct APList *parse_db_str(char *str)
{
	struct APList *curr=NULL;
	char *ip=NULL, *passwd=NULL, mess[1024];
	int i=0, pos=0, j=0;

	while(str[i] != '\0') {
		if(str[i] == ':') {
			switch (pos) {
			case 0: 
				ip = (char *) malloc(j+1);
				memcpy(ip, mess, j+1);
				ip[j] = '\0';
				break;
			case 1:
                                passwd = (char *) malloc(j+1);
                                memcpy(passwd, mess, j+1);
                                passwd[j] = '\0';
				break;
			}
			i++;
			j=0;
			pos++;
		
		}
		else
			mess[j++] = str[i++];
	}
			
	if (pos==2 && ip && passwd) {
		mess[j]='\0';
                curr = (struct APList *) malloc(sizeof(struct APList));
                curr->type = atoi(mess);
                curr->next = NULL;
                curr->ip = (char *) malloc(strlen(ip)+1);
	        strcpy(curr->ip, ip);
		curr->passwd = (char *) malloc(strlen(passwd)+1);
                strcpy(curr->passwd, passwd);
	}
	
	if(passwd)
		free(passwd);
	if(ip)
		free(ip);
 
	return curr;
}


int get_opts()
{
        extern char ap_type, *community;
	extern struct in_addr ap_ip;
	extern int sockfd;
	
	char *home_dir, buf[1024], mess[64];
	int c;
    	int fd, rval=0, pos;
    	signed int j, i, begin, end, record_num=0;
	char message[50];
	struct APList *first=NULL, *curr=NULL, *pmac; 
    struct sockaddr_in client;

    memset(&client, 0, sizeof client);
    client.sin_family = AF_INET;
    client.sin_port = INADDR_ANY;
    client.sin_addr.s_addr = INADDR_ANY;


   if ((home_dir = getenv("HOME")) == NULL)
	return 0;
    sprintf(buf, "%s/.ap-config", home_dir);
    if ((fd = open(buf, O_RDONLY)) == -1)
	return 0;
    pos=0;
 while((j = read(fd, buf, sizeof(buf)))>0) 
    for(i=0; i < j; i++) {
	if (buf[i] == 0x0a){
		mess[pos]='\0';
            	if (first == NULL) {
              		if ((first = parse_db_str(mess))!=NULL) {
				curr=first;
				record_num=1;
			}
            	} else {
                   if ((curr->next = parse_db_str(mess)) != NULL) {
                   	curr = curr->next;
		   	record_num++;
		}
            	}
		pos=0;
	} else	
		mess[pos++] = buf[i];
    }

	 mess[pos]='\0';
      	if (first == NULL) {
       		if ((first = parse_db_str(mess))!=NULL) {
			curr=first;
			record_num=1;
		}
        } else {
                if ((curr->next = parse_db_str(mess)) != NULL) 
                   	curr = curr->next;
		   	record_num++;
        }

    close(fd);
	if(!record_num)
		return 0;
    
    mvwaddstr(main_sub, 0, 3, _("NUM       IP ADDRESS   TYPE"));
	print_title(_("Choose AP to connect")); 
    begin = 1;
    end = (MAX_LINES < record_num) ? MAX_LINES : record_num;
    _scroll_rows(first, begin, end);
   noecho();
	print_help(_("1-9,C: connect; N: new; D: delete; W: save; Q: quit; arrows: scroll"));
        while (1) {
	        switch (c = getch()) {
		        case 'q':
		        case 'Q':
				exit_program();
			case 'n':
			case 'N':
				goto quit;
		        case '0':
		        case '1':
		        case '2':
		        case '3':
		        case '4':
		        case '5':
		        case '6':
		        case '7':
		        case '8':
		        case '9':
			        i = c - '0';
			        if (record_num <= i || i <= 0)
					goto wrong_num;
		                curr = first;
			        while (--i > 0)
					curr = curr->next;
				inet_aton(curr->ip, &ap_ip);
				if (community)
		    			free(community);
				i = strlen(curr->passwd) + 1;
				community = (char *) malloc(i);
				strncpy(community, curr->passwd, i);
				ap_type = curr->type;
				rval=1;
				if (sockfd)
					close(sockfd);
    				if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
					rval=0;
				if (bind(sockfd, (struct sockaddr *) &client, SIZE) == -1)
					rval=0;
				print_bottom(inet_ntoa(ap_ip));
				goto quit;
		        case 'c':
		        case 'C':
				mvwaddstr(main_sub, 1, 1, _("Connect to AP num:"));
			        get_value(message, 1, 20, 6);
			        i = atoi(message);
			        if (record_num <= i || i <= 0)
					goto wrong_num;
		                curr = first;
			        while (--i > 0)
					curr = curr->next;
				inet_aton(curr->ip, &ap_ip);
				if (community)
		    			free(community);
				i = strlen(curr->passwd) + 1;
				community = (char *) malloc(i);
				strncpy(community, curr->passwd, i);
				ap_type = curr->type;
				rval=1;
				if (sockfd)
					close(sockfd);
    				if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
					rval=0;
				if (bind(sockfd, (struct sockaddr *) &client, SIZE) == -1)
					rval=0;
				print_bottom(inet_ntoa(ap_ip));
				goto quit;
 		        case 'd':
		        case 'D':
				mvwaddstr(main_sub, 1, 0, _("Delete num:"));
			        get_value(message, 1, 15, 6);
			        i = atoi(message);
			        if (record_num <= i || i <= 0)
			                goto wrong_num;
			        if (i == 1) {
			                curr = first;
					first = first->next;
					free(curr);
				} else {
				        curr = first;
				        while (--i > 1)
				           curr = curr->next;
				           pmac = curr->next;
				           curr->next = pmac->next;
				           free(pmac);
				}
				record_num--;
				begin = 1;
				end = (MAX_LINES < record_num) ? MAX_LINES : record_num;
				_scroll_rows(first, begin, end);
			   wrong_num:
			         clear_main_new(1, 2);
		            continue;
        case KEY_DOWN:
        case KEY_RIGHT:
            if (end < record_num) {
                begin++;
                end++;
                _scroll_rows(first, begin, end);
            }

            continue;
        case KEY_UP:
        case KEY_LEFT:
            if (begin > 1) {
	                begin--;
	                end--;
	                _scroll_rows(first, begin, end);
	            }
            continue;
        
	case 'w':
	case 'W':
		sprintf(buf, "%s/.ap-config", home_dir);
        	if ((fd = creat(buf, 0600)) != -1) {
		curr=first;
            	while (curr) {
                    	sprintf(buf, "%s:%s:%d\n", curr->ip, curr->passwd, curr->type);
                	write(fd, buf, strlen(buf));
                	curr = curr->next;
            		}
            	close(fd);
        	}
	        continue;
	}
}
/*
    print_help(ANY_KEY);
    getch();
*/  quit:
    while ((curr = first)) {
	     first = curr->next;
	     free(curr->ip);
	     free(curr->passwd);
	     free(curr);
	}
	print_help("");
	print_title("");
	wclear(main_sub);
	wrefresh(main_sub);
	return rval;
}

void save_Stations(struct MacListStat *curr)
{
    int fd;
    extern short ap_type;
    char *home_dir;
    char message[1024];
    if ((home_dir = getenv("HOME"))) {
	sprintf(message, "%s/ap-%s.stations", home_dir,
		ap_types[ap_type]);
	if ((fd = creat(message, 0600)) != -1) {
	    while (curr) {
		sprintf(message, "%02X%02X%02X%02X%02X%02X\n",
			curr->addr[0] & 0xFF, curr->addr[1] & 0xFF,
			curr->addr[2] & 0xFF, curr->addr[3] & 0xFF,
			curr->addr[4] & 0xFF, curr->addr[5] & 0xFF);
		write(fd, message, 13);
		curr = curr->next;
	    }
	    close(fd);
	}
    }
}

