/*
 *      auth.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include "ap-utils.h"
#include <ncurses.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <ncurses.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LINES LINES-6
#define PACKET_ERROR _("AuthorizedMacTableString packet error")

extern WINDOW *main_sub;
extern int LINES;
extern short ap_type;

void AuthMAC()
{
    struct AuthorizedMacTableString {
	unsigned int short Action;
	unsigned int short NumOfAllTableAddresses;
	unsigned int short NumOfCurrentAddress;
	unsigned char MacAddress[6];
    } *AuthMac = NULL, get;

    struct MacListStat *pmac, *first = NULL, *curr = NULL;
    uint32_t auth_mac_hw;

    char EnableAuthMAC[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01,
	0x02, 0x06, 0x01, 0x00
    };
    char AutorizedMac[] = { 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01,
	0x02, 0x06, 0x02, 0x00
    };

    char message[1024], m_authmac = 0;
    int i, total_mac, auth_mac = 0, mac_num = 0, begin, end;
    varbind varbinds[1];
	if (ME102 == ap_type) {
		EnableAuthMAC[5] = 0xE0;
		EnableAuthMAC[6] = 0x3E;
		AutorizedMac[5] = 0xE0;
		AutorizedMac[6] = 0x3E;
	}

    varbinds[0].oid = EnableAuthMAC;
    varbinds[0].len_oid = sizeof(EnableAuthMAC);
    varbinds[0].type = NULL_VALUE;
    varbinds[0].len_val = 0;
    print_help(WAIT_RET);
    if (snmp(varbinds, 1, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }
    print_title(MAC_TITLE);

    auth_mac = *(varbinds[0].value);
    sprintf(message, MAC_AUTH, (auth_mac == 1) ? ON : OFF);
    mvwaddstr(main_sub, 0, 0, message);
    mvwaddstr(main_sub, 2, 5, MAC_HEADER);
    wrefresh(main_sub);

    total_mac = 0;
    mac_num = 0;

    while (mac_num <= total_mac) {
	get.Action = 0x02; rshort(get.Action);
	get.NumOfAllTableAddresses = total_mac;	rshort(get.NumOfAllTableAddresses);
	get.NumOfCurrentAddress = mac_num; rshort(get.NumOfCurrentAddress);

	varbinds[0].oid = AutorizedMac;
	varbinds[0].len_oid = sizeof(AutorizedMac);
	varbinds[0].value = (char *) &get;
	varbinds[0].len_val = 12;
	varbinds[0].type = STRING_VALUE;

	if (snmp(varbinds, 1, SET) <= 0) {
	    print_help(ERR_RET);
	    goto exit;
	}

	if (varbinds[0].len_val == 12) {
	    if (AuthMac)
		free(AuthMac);
	    AuthMac =
		(struct AuthorizedMacTableString *) malloc(varbinds[0].
							   len_val);
	    memcpy(AuthMac, varbinds[0].value, varbinds[0].len_val);
/*	    AuthMac =
		(struct AuthorizedMacTableString *) varbinds[0].value;*/
	} else {
	    print_help(PACKET_ERROR);
	    goto exit;
	}

	rshort(AuthMac->NumOfAllTableAddresses);
	total_mac =
	    (AuthMac->NumOfAllTableAddresses ==
	     65535) ? 0 : AuthMac->NumOfAllTableAddresses;

	if (mac_num) {
	    if (first == NULL) {
		first = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = first;
	    } else {
		curr->next = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = curr->next;
	    }
	    memcpy(curr->addr, AuthMac->MacAddress, 6);
	    curr->next = NULL;
	}
	mac_num++;
    }

    begin = 1;
    end = (MAX_LINES < mac_num) ? MAX_LINES : mac_num;
    scroll_rows(first, begin, end, 3, 0);

    noecho();

    print_help(MAC_HELP);
    while (1) {
	switch (getch()) {
	case 'q':
	case 'Q':
	    goto quit;
	case 'a':
	case 'A':
	    auth_mac = on_off(19, 0);
	    clear_main_new(0, 1);
	    sprintf(message, MAC_AUTH, (auth_mac == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 0, 0, message);
	    wrefresh(main_sub);
	    m_authmac = 1;
	    continue;
	case 'd':
	case 'D':
	    mvwaddstr(main_sub, 1, 0, MAC_DEL);
	    get_value(message, 1, 20, 5);
	    i = atoi(message);
	    if (mac_num <= i || i <= 0)
		goto wrong_num;
	    if (i == 1) {
		pmac = first;
		first = first->next;
		free(pmac);
	    } else {
		curr = first;
		while (--i > 1)
		    curr = curr->next;
		pmac = curr->next;
		curr->next = pmac->next;
		free(pmac);
	    }
	    mac_num--;
	    begin = 1;
	    end = (MAX_LINES < mac_num) ? MAX_LINES : mac_num;
	    scroll_rows(first, begin, end, 3, 0);
	  wrong_num:
	    clear_main_new(1, 2);
	    continue;
	case 'n':
	case 'N':
	    mvwaddstr(main_sub, 1, 0, MAC_ADD);
	    curr = first;
	    while (curr && curr->next)
		curr = curr->next;
	    if (first == NULL) {
		first = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = first;
	    } else {
		curr->next = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = curr->next;
	    }
	    curr->next = NULL;
	    mac_num++;
/*	    get_value(message, 1, 15, 13);

	    for (i = 0; i < 6; i++) {
		mess[0] = message[2 * i];
		mess[1] = message[2 * i + 1];
		mess[2] = '\0';
		curr->addr[i] = strtol(mess, NULL, 16);
	    }
	    clear_main_new(1, 2);
*/
		get_mac(1, 15, curr->addr);
	    begin = 1;
	    end = (MAX_LINES < mac_num) ? MAX_LINES : mac_num;
	    scroll_rows(first, begin, end, 3, 0);
	    continue;
	case 'w':
	case 'W':
	    if (m_authmac) {
		auth_mac_hw = swap4(auth_mac);
		varbinds[0].oid = EnableAuthMAC;
		varbinds[0].len_oid = sizeof(EnableAuthMAC);
		varbinds[0].type = INT_VALUE;
		varbinds[0].value = (char *) &auth_mac_hw;
		varbinds[0].len_val = 1;
		print_help(WAIT_SET);
		if (snmp(varbinds, 1, SET) <= 0) {
		    print_help(ERR_RET);
		    goto exit;
		}
	    }
	    curr = first;
	    i = 1;
	    while (curr != NULL) {
		get.Action = 0x01; rshort(get.Action);
		get.NumOfAllTableAddresses = mac_num - 1; rshort(get.NumOfAllTableAddresses);
		get.NumOfCurrentAddress = i; rshort(get.NumOfCurrentAddress);
		memcpy(get.MacAddress, curr->addr, 6);
		varbinds[0].oid = AutorizedMac;
		varbinds[0].len_oid = sizeof(AutorizedMac);
		varbinds[0].value = (char *) &get;
		varbinds[0].len_val = 12;
		varbinds[0].type = STRING_VALUE;
		print_help(WAIT_SET);
		if (snmp(varbinds, 1, SET) <= 0) {
		    print_help(ERR_RET);
		    goto exit;
		}
		if (varbinds[0].len_val != 12) {
		    print_help(PACKET_ERROR);
		    goto exit;
		}
		curr = curr->next;
		i++;
	    }
	    print_help(DONE_SET);
	    goto exit;
	case KEY_DOWN:
	case KEY_RIGHT:
	    if (end < mac_num) {
		begin++;
		end++;
		scroll_rows(first, begin, end, 3, 0);
	    }

	    continue;
	case KEY_UP:
	case KEY_LEFT:
	    if (begin > 1) {
		begin--;
		end--;
		scroll_rows(first, begin, end, 3, 0);
	    }
	    continue;
	}
	continue;
    }

    print_help(ANY_KEY);
  exit:
    getch();
  quit:
    while ((curr = first)) {
	first = curr->next;
	free(curr);
    }
    if (AuthMac)
	free(AuthMac);
    print_title("");
    clear_main(0);
}

void nwn_auth_mac()
{
    struct MacListStat *pmac, *first = NULL, *curr = NULL;
    char Mac[] =
	{ 0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x03, 0x02,
	0x02, 0x01, 0x02, 0x00
    };
    char MacAllow[] =
	{ 0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x03, 0x02,
	0x02, 0x01, 0x03, 0x00
    };
    char MacRowStatus[] =
	{ 0x2b, 0x06, 0x01, 0x04, 0x01, 0x87, 0x29, 0x03, 0x01, 0x03, 0x02,
	0x02, 0x01, 0x04, 0x00
    };
    char message[1024], auth_enable[] =
	{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
    char destroy = 6, create = 4, allow = 1;
    int i, auth_mac = 0, mac_num = 0, begin, end;
    varbind varbinds[3];
    print_title(MAC_TITLE);

    mvwaddstr(main_sub, 2, 5, MAC_HEADER);
    wrefresh(main_sub);
    print_help(WAIT_RET);

    mac_num = 1;
    varbinds[0].oid = Mac;
    varbinds[0].len_oid = sizeof(Mac);
    varbinds[0].value = Mac;
    varbinds[0].len_val = 0;
    varbinds[0].type = NULL_VALUE;
    if (snmp(varbinds, 1, GET_NEXT) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }

    while (memcmp(varbinds[0].oid, Mac, sizeof(Mac) - 1) == 0) {

	Mac[sizeof(Mac) - 1] = varbinds[0].oid[sizeof(Mac) - 1];
	MacAllow[sizeof(MacAllow) - 1] = varbinds[0].oid[sizeof(Mac) - 1];
	MacRowStatus[sizeof(MacRowStatus) - 1] =
	    varbinds[0].oid[sizeof(Mac) - 1];

	varbinds[0].oid = Mac;
	varbinds[0].len_oid = sizeof(Mac);
	varbinds[0].value = Mac;
	varbinds[0].len_val = 0;
	varbinds[0].type = NULL_VALUE;
	varbinds[1].oid = MacAllow;
	varbinds[1].len_oid = sizeof(MacAllow);
	varbinds[1].value = Mac;
	varbinds[1].len_val = 0;
	varbinds[1].type = NULL_VALUE;
	varbinds[2].oid = MacRowStatus;
	varbinds[2].len_oid = sizeof(MacRowStatus);
	varbinds[2].value = Mac;
	varbinds[2].len_val = 0;
	varbinds[2].type = NULL_VALUE;
	if (snmp(varbinds, 3, GET) <= 0) {
	    print_help(ERR_RET);
	    goto exit;
	}
	if (memcmp(auth_enable, varbinds[0].value, 6)) {
	    if (first == NULL) {
		first = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = first;
	    } else {
		curr->next = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = curr->next;
	    }
	    memcpy(curr->addr, varbinds[0].value, 6);
	    curr->next = NULL;
	    mac_num++;
	} else
	    auth_mac = 1;


	varbinds[0].oid = Mac;
	varbinds[0].len_oid = sizeof(Mac);
	varbinds[0].value = Mac;
	varbinds[0].len_val = 0;
	varbinds[0].type = NULL_VALUE;
	if (snmp(varbinds, 1, GET_NEXT) <= 0) {
	    print_help(ERR_RET);
	    goto exit;
	}
    }

    begin = 1;
    end = (MAX_LINES < mac_num) ? MAX_LINES : mac_num;

    sprintf(message, MAC_AUTH, (auth_mac) ? OFF : ON);
    mvwaddstr(main_sub, 0, 0, message);

    scroll_rows(first, begin, end, 3, 0);

    noecho();

    print_help(MAC_HELP);
    while (1) {
	switch (getch()) {
	case 'Q':
	case 'q':
	    goto quit;
	case 'a':
	    auth_mac = on_off(22, 0) - 1;
	    clear_main_new(0, 1);
	    sprintf(message, MAC_AUTH, (auth_mac) ? OFF : ON);
	    mvwaddstr(main_sub, 0, 0, message);
	    wrefresh(main_sub);
	    continue;
	case 'd':
	    mvwaddstr(main_sub, 1, 0, MAC_DEL);
	    get_value(message, 1, 20, 5);
	    i = atoi(message);
	    if (mac_num <= i || i <= 0)
		goto wrong_num;

	    if (i == 1) {
		pmac = first;
		first = first->next;
		free(pmac);
	    } else {
		curr = first;
		while (--i > 1)
		    curr = curr->next;
		pmac = curr->next;
		curr->next = pmac->next;
		free(pmac);
	    }
	    mac_num--;

	    begin = 1;
	    end = (MAX_LINES < mac_num) ? MAX_LINES : mac_num;
	    scroll_rows(first, begin, end, 3, 0);
	  wrong_num:
	    clear_main_new(1, 2);
	    continue;
	case 'n':
	case 'N':
	    mvwaddstr(main_sub, 1, 0, MAC_ADD);
	    curr = first;
	    while (curr && curr->next)
		curr = curr->next;
	    if (first == NULL) {
		first = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = first;
	    } else {
		curr->next = (struct MacListStat *)
		    malloc(sizeof(struct MacListStat));
		curr = curr->next;
	    }
	    curr->next = NULL;
	    mac_num++;
	    get_mac(1, 20, curr->addr);
/*	    for (i = 0; i < 6; i++) {
		get_value(message, 1, 20 + i * 3, 3);
		curr->addr[i] = strtol(message, NULL, 16);
	    }
	    clear_main_new(1, 2);
*/	    begin = 1;
	    end = (MAX_LINES < mac_num) ? MAX_LINES : mac_num;
	    scroll_rows(first, begin, end, 3, 0);
	    continue;
	case 'w':
	case 'W':
	    print_help(WAIT_SET);

	    Mac[sizeof(Mac) - 1] = 0;

	    varbinds[0].oid = Mac;
	    varbinds[0].len_oid = sizeof(Mac);
	    varbinds[0].value = Mac;
	    varbinds[0].len_val = 0;
	    varbinds[0].type = NULL_VALUE;
	    if (snmp(varbinds, 1, GET_NEXT) <= 0) {
		print_help(ERR_RET);
		goto exit;
	    }
	    while (memcmp(varbinds[0].oid, Mac, sizeof(Mac) - 1) == 0) {

		MacRowStatus[sizeof(MacRowStatus) - 1] =
		    varbinds[0].oid[sizeof(Mac) - 1];
		varbinds[0].oid = MacRowStatus;
		varbinds[0].len_oid = sizeof(MacRowStatus);
		varbinds[0].value = &destroy;
		varbinds[0].len_val = 1;
		varbinds[0].type = INT_VALUE;
		if (snmp(varbinds, 1, SET) <= 0) {
		    print_help(ERR_RET);
		    goto exit;
		}
		varbinds[0].oid = Mac;
		varbinds[0].len_oid = sizeof(Mac);
		varbinds[0].value = Mac;
		varbinds[0].len_val = 0;
		varbinds[0].type = NULL_VALUE;
		if (snmp(varbinds, 1, GET_NEXT) <= 0) {
		    print_help(ERR_RET);
		    goto exit;
		}
	    }


	    curr = first;
	    i = 1;

	    if (auth_mac) {
		Mac[sizeof(Mac) - 1] = i;
		MacAllow[sizeof(MacAllow) - 1] = i;
		MacRowStatus[sizeof(MacRowStatus) - 1] = i;

		varbinds[0].oid = MacRowStatus;
		varbinds[0].len_oid = sizeof(MacRowStatus);
		varbinds[0].value = &create;
		varbinds[0].len_val = 1;
		varbinds[0].type = INT_VALUE;
		varbinds[1].oid = Mac;
		varbinds[1].len_oid = sizeof(Mac);
		varbinds[1].value = auth_enable;
		varbinds[1].len_val = 6;
		varbinds[1].type = STRING_VALUE;
		varbinds[2].oid = MacAllow;
		varbinds[2].len_oid = sizeof(MacAllow);
		varbinds[2].value = &allow;
		varbinds[2].len_val = 1;
		varbinds[2].type = INT_VALUE;
		print_help(WAIT_SET);
		if (snmp(varbinds, 3, SET) <= 0) {
		    print_help(ERR_RET);
		    goto exit;
		}
		i++;
	    }




	    while (curr != NULL) {
		Mac[sizeof(Mac) - 1] = i;
		MacAllow[sizeof(MacAllow) - 1] = i;
		MacRowStatus[sizeof(MacRowStatus) - 1] = i;

		varbinds[0].oid = MacRowStatus;
		varbinds[0].len_oid = sizeof(MacRowStatus);
		varbinds[0].value = &create;
		varbinds[0].len_val = 1;
		varbinds[0].type = INT_VALUE;
		varbinds[1].oid = Mac;
		varbinds[1].len_oid = sizeof(Mac);
		varbinds[1].value = curr->addr;
		varbinds[1].len_val = 6;
		varbinds[1].type = STRING_VALUE;
		varbinds[2].oid = MacAllow;
		varbinds[2].len_oid = sizeof(MacAllow);
		varbinds[2].value = &allow;
		varbinds[2].len_val = 1;
		varbinds[2].type = INT_VALUE;
		print_help(WAIT_SET);
		if (snmp(varbinds, 3, SET) <= 0) {
		    print_help(ERR_RET);
		    goto exit;
		}
		curr = curr->next;
		i++;
	    }
	    print_help(DONE_SET);
	    goto exit;
	case KEY_DOWN:
	case KEY_RIGHT:
	    if (end < mac_num) {
		begin++;
		end++;
		scroll_rows(first, begin, end, 3, 0);
	    }

	    continue;
	case KEY_UP:
	case KEY_LEFT:
	    if (begin > 1) {
		begin--;
		end--;
		scroll_rows(first, begin, end, 3, 0);
	    }
	    continue;
	}
	continue;
    }

    print_help(ANY_KEY);
  exit:
    getch();
  quit:
    while ((curr = first)) {
	first = curr->next;
	free(curr);
    }
    print_title("");
    clear_main(0);
}
