/*
 *    ap-utils.h from Wireless Access Point Utilites for Unix
 *  Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef	_AP_CNF
#define _AP_CNF 1

#include <stdint.h>

#define TITLE "Wireless Access Point Utilites for Unix"


/* GNU gettext stuff*/
#include <locale.h>
#include <libgnuintl.h>
#define _(String) gettext (String)


#define ATMEL 0
#define NWN 1
#define ME102 2
#define AP_TYPE(d) (d) ? (1 == d) ? "NWN" : "ME102" : "ATMEL"


#ifdef WORDS_BIGENDIAN 
/* a quick-and-dirty macro to unconditionally swap bytes in 4-byte integers
 * between big-endian and little-endian ordering */
#define swap2(d) ((((d) >> 8) & 0x00ff) | (((d) << 8) & 0xff00))
#define swap4(d) \
        ((((d) >> 24) & 0x000000ff) | (((d) >>  8) & 0x0000ff00) | \
         (((d) <<  8) & 0x00ff0000) | (((d) << 24) & 0xff000000))
#else
#define swap2(d) d
#define swap4(n) n
#endif

#define rlong(a)	((a) = swap4(a))
#define wlong(a)	((a) = swap4(a))
#define rshort(a)	((a) = swap2(a))
#define wshort(a)	((a) = swap2(a))


#define ON _("on")
#define OFF _("off")
#define BASIC _("basic")

#define ANY_KEY _("Press any key to continue.")

#define MAC _("Mac Address: %02X%02X%02X%02X%02X%02X")

#define ENCRYPT _("[E] Standard encryption mechanism: %s")

#define OSYS _("Open System")
#define SH_KEY _("Shared Key")
#define BOTH_TYPE _("Both Type")

#define CHANNEL _("[C] Frequency Channel: %02u (%u MHz)")
#define AUTH _("[A] Auth Type: %s")

#define RTS_TR _("[R] RTS Threshold: %d")
#define FRG_TR _("[F] Fragmentation Threshold: %d")

#define RATES _("Basic and Supported Rates:")
#define RATES_HEAD _("Key   Rate  Status")

#define ESSID "[D] ESSID:"
#define BSS_NAME _("[N] AP Name:")

#define TRAPS _("[S] SNMP Traps: %s")

#define ANTENNA_TX _("Transmit Antenna: [O] Left %3s, [P] Right %3s")
#define ANTENNA_RX _("Receive  Antenna: [U] Left %3s, [I] Right %3s")
#define ANTENNA_DV _("Diversity Select: [T] Left %3s, [Y] Right %3s")

#define ERR_SET _("Unable to write data to AP. Press any key to continue.")
#define ERR_RET _("Unable to retrieve data from AP. Press any key to continue.")
#define WAIT_RET _("Retrieving data from AP. Please wait...")
#define WAIT_SET _("Writing data to AP. Please wait...")
#define DONE_SET _("Write configuration to AP done. Press any key to continue.")

#define CREATE_SOCKET_ERROR _("Create socket error. Press any key.")
#define BIND_SOCKET_ERROR _("Bind socket error. Press any key.")

#define COMMUNITY_TOP_HEADER _("Set community/password")
#define COMMUNITY_HEADER1 _("Key Access Level") 
#define COMMUNITY_HEADER2 _("Community/Password")
#define COMMUNITY_USER  _("[U] User")
#define COMMUNITY_ADMIN  _("[A] Administrator")
#define COMMUNITY_HELP _("KEY - set community/password; W - write config to AP; Q - exit")

#define MAIN_MENU  _("Back to main menu")
#define MENU_EXIT _("Exit program")
#define MENU_SHELL _("Run subshell. To return type 'exit'")
#define MENU_ABOUT _("Short info about program")
#define MENU_SEARCH _("Find connected Access Points")
#define MENU_CONNECT _("Set connection options: ip and community")
#define MENU_ENCRYPT _("Set encryption, edit WEP keys")
#define MENU_MAC _("Set mac authorization, edit mac authorization table")
#define MENU_COMMUNITY _("Set SNMP community/password to access AP")
#define MENU_SYSINFO _("Get info about AP hardware and software")
#define MENU_WIRELESS _("Get wireless ports statistics")
#define MENU_STAS _("Get list of current associated stations")
#define MENU_INFO _("Getting info and statistics from AP")
#define MENU_CONFIG  _("Setting various configuration options")

#define MAC_AUTH _("[A] Mac authorization: %s")
#define MAC_TITLE _("Authorized Mac Addresses")
#define MAC_HEADER _("NUM     MAC address")
#define MAC_HELP _("A - auth; N - new; D - del; arrows - scroll; W - write conf; Q - quit")
#define MAC_DEL  _("Delete Num:")
#define MAC_ADD  _("Enter Mac:")


#define INT_VALUE	0x02
#define STRING_VALUE	0x04
#define NULL_VALUE	0x05
#define OID_VALUE	0x06

#define GET             0xA0
#define GET_NEXT        0xA1
#define RESPONSE        0xA2
#define SET             0xA3
#define TRAP            0xA4

#define ASN_HEADER	0x30


#define SIZE sizeof(struct sockaddr_in)
#define basic(i) (i & 0x80) ? BASIC : (i) ? ON : OFF


#define MCOLS 15 /* width of menu window */
#define LAST_ROW LINES-5


struct umitems {
	char *item;
	char *help;
	void (*func)();
	int is_menu;
};

typedef struct VarBind {
    unsigned char *oid;
    int len_oid;
    unsigned char *value;
    int len_val;
    unsigned char type;
} varbind;

struct EthernetRxStatistics {
	uint32_t TotalBytesRx;
	uint32_t TotalPacketsRx;
	uint32_t PacketCRCErrorRx;
	uint32_t MulticastPacketRx;
	uint32_t BroadcastPacketRx;
	uint32_t ControlFramesRx;
	uint32_t PauseFramesRx;
	uint32_t UnknownOPCodeRx;
	uint32_t AlignmentRxError;
	uint32_t LengthOutOfRangeRx;
	uint32_t CodeErrorRx;
	uint32_t FalseCarrierRx;
	uint32_t UndersizePacketsRx;
	uint32_t OversizePacketsRx;
	uint32_t TotalFragmentsRx;
	uint32_t TotalJabberRx;
};

struct EthernetTxStatistics {
	uint32_t TotalBytesTx;
	uint32_t TotalPacketsTx;
	uint32_t PacketCRCErrorTx;
	uint32_t MulticastPacketTx;
	uint32_t BroadcastPacketTx;
	uint32_t UnicastPacketTx;
	uint32_t PauseFramesTx;
	uint32_t SingleDeferPacketTx;
	uint32_t MultiDeferPacketsTx;
	uint32_t SingleCollisionsTx;
	uint32_t MultiCollisionsTx;
	uint32_t LateCollisionsTx;
	uint32_t ExcessiveCollisionTx;
	uint32_t TotalCollisionsTx;
};

struct WirelessStatistics {
	uint32_t UnicastTransmittedPackets;
	uint32_t BroadcastTransmittedPackets;
	uint32_t MulticastTransmittedPackets;
	uint32_t TransmittedBeacon;
	uint32_t TransmittedACK;
	uint32_t TransmittedRTS;
	uint32_t TransmittedCTS;
	uint32_t UnicastReceivedPackets;
	uint32_t BroadcastReceivedPackets;
	uint32_t MulticastReceivedPackets;
	uint32_t ReceivedBeacon;
	uint32_t ReceivedACK;
	uint32_t ReceivedRTS;
	uint32_t ReceivedCTS;
	uint32_t ACKFailure;
	uint32_t CTSFailure;
	uint32_t RetryPackets;
	uint32_t ReceivedDuplicate;
	uint32_t FailedPackets;
	uint32_t AgedPackets;
	uint32_t FCSError;
	uint32_t InvalidPLCP;
};

struct HARD_CONFIGURATION_STUCT {
	uint32_t StructVersion;
	unsigned char MacAddress[6];
	unsigned short Reserved;
	uint32_t RegulationDomain;
	uint32_t ProductType;
	unsigned char OEMName[32];
	uint32_t OEMID;
	unsigned char ProductName[32];
	uint32_t HardwareRevision;
};

struct MacListStat {
    unsigned char addr[6];
    struct MacListStat *next;
    int quality;
    int idle;
    int rssi;
    
};

/* Function prototypes specific common fot both utilites */

/* service */
extern char * oui2manufacturer(char *);
extern int ch_list(int, char **);
extern void auth(void);
extern void about(void);
extern void draw_menu_win(void);
extern void main_menu(void);
extern void print_title(char *);
extern void print_bottom(char *);
extern void print_help(char *);
extern void clear_main(int);
extern void clear_main_new(int, int);
extern int  get_value(char *, int, int, int);
extern void get_mac(int, int, char *);
extern int  menu_choose(int, int, char **, unsigned int);
extern int  on_off(int, int);
extern void scroll_rows(struct MacListStat *, int, int, int, int);
extern void exit_shell(void);
extern void exit_program(void);
extern int  get_opts(void);
extern void save_Stations(struct MacListStat *);
extern void uni_menu(struct umitems *umenu, int num);

/* AP */
extern void AuthorizedSettings(void);
extern void AuthMAC(void);
extern void wireless(void);
extern void briging(void);
extern void wep(void);
extern void WirelessStat(void);
extern void stations(void);
extern void sysinfo(void);
extern void ap_search(void);

/* snmp engine*/
extern int snmp(varbind *, int, int);
extern int ber(char *, varbind *, int, int);

/* Function prototypes specific for Atmel utility */
extern void reset(void);
extern void defaults(void);
extern void upload(void);
extern int  SysUpload(void);
extern int  SysReset(void);
extern void EthStat(void);
extern void APs(void);
extern void power(void);
extern void test(void);

/* Function prototypes specific for NWN utility */
extern void latest(void);
extern int  get_RegDomain(void);
extern void advanced(void);
extern void command_menu(void);
extern void nwn_wireless(void);
extern void nwn_sysinfo(void);
extern void nwn_wep(void);
extern void nwn_stations(void);
extern void nwn_wireless_stat(void);
extern void nwn_auth_mac(void);

#endif
