/*  SpiralLoops
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef SAMPLE
#define SAMPLE

#include <assert.h>
#include <iostream>
#include "SpiralInfo.h"

static const unsigned short UMAX_LEV  = 65535;
static const short          MAX_LEV   = 32768;
static const float          FREQ_CONV = 5.0f;
static const float          CV_CONV   = UMAX_LEV/128;
static const float          VAL2CV    = 1.0f/MAX_LEV;
static const float          UVAL2CV   = 1.0f/UMAX_LEV;

inline float Linear(float bot,float top,float pos,float val1,float val2) 
{ 
    float t=(pos-bot)/(top-bot); 
    return val1*t + val2*(1.0f-t); 
}

class Sample
{
public:

	Sample(int Len=0);
	Sample(const Sample &rhs);
	Sample(short *S, int Len);
	~Sample();

	bool Allocate(int Size);
	void Clear();
	void Zero();
	void Insert(const Sample &S, int Pos);
	void Add(const Sample &S);
	void Mix(const Sample &S, int Pos);
	void Remove(int Start, int End);
	void Reverse(int Start, int End);
	void Move(int Dist);
	void GetRegion(Sample &S, int Start, int End);
	const short *GetBuffer() const {return m_Data;}
	short *GetNonConstBuffer() {return m_Data;}
	int  GetLength() const {return m_Length;} 
	int  GetLengthInBytes() const {return m_Length*2;} 
	void Expand(int Length);
	void Shrink(int Length);
	void CropTo(int NewLength);

	inline short &Sample::operator[](int i) const
	{
		assert(i>=0 && i<m_Length);
		return m_Data[i];
	}

	inline void Sample::Set(int i, long int v) 
	{	
		assert(i>=0 && i<m_Length);
		// clip
		if (v<-SpiralInfo::MAXSAMPLE) v=-SpiralInfo::MAXSAMPLE;
		if (v>SpiralInfo::MAXSAMPLE)  v=SpiralInfo::MAXSAMPLE;
			
		m_Data[i]=(short)v;
	}	
	
	inline Sample &Sample::operator=(const Sample &rhs)
	{
		Allocate(rhs.GetLength());		
		memcpy(m_Data,rhs.GetBuffer(),GetLengthInBytes());
		return *this;
	}


private:

	short *m_Data;
	long  int  m_Length;
};

#endif
