/*  SpiralLoops
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef SPIRALLOOPS
#define SPIRALLOOPS

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Value_Output.H>
#include "GUI/Widgets/Fl_Knob.H"
#include <strstream>
#include <iostream>
#include <map>
#include "GUI/DelayGUI.h"
#include "GUI/ReverbGUI.h"
#include "GUI/OutputGUI.h"
#include "GUI/LoopGUI.h"
#include "GUI/ScopeGUI.h"
#include "SpiralLoopsInfo.h"
#include "SpiralSound/Delay.h"
#include "SpiralSound/Reverb.h"
#include "SpiralSound/Sample.h"

class Loop;

class LoopWin
{
	public:
		LoopWin() {}
		~LoopWin();
				
		Loop    *m_Loop;
		LoopGUI *m_LoopGUI;
};

class Loops
{
public:
	Loops();
	~Loops();
	
	Fl_Window *CreateWindow();
	void       DoIdle();
	void       AddLoop();
	
	// copy buffer funcs
	void   Cut(Sample &buf, int start, int end);
	void   Copy(Sample buf, int start, int end);
	void   Paste(Sample &buf, int start);
	void   PasteMix(Sample &buf, int start);
	
	// master loop access funcs
	void       SetMaster(int id, float s, float sp);
	const float GetMasterLength() { return m_MasterLength; }
	const float GetMasterSpeed()  { return m_MasterSpeed;  }
	const float GetMagic()        { return m_Magic; }
	
	// plugin handling functions
	int    OpenPlugin(const char *PluginName);
    int    LinkPlugin();
    int    ClosePlugin();
    Fl_Window *CreatePlugin(){return Create();}
    Sample*RunPlugin(){return Run();}
    void   DestroyPlugin(){Destroy();}
	Fl_Window *GetPluginWindow() const {return m_PluginWindow;}
	
	Fl_Window *Window;
	
private:

	Fl_Window *(*Create)(void);
    Sample*(*Run)(void);
    void   (*Destroy)(void);
    void    *handle;
    char    *error;
	Sample  *m_PluginBuffer;
	bool	 m_PluginOpen;
	bool	 m_PluginLinked;
 	bool 	 m_PluginPaused;
	Fl_Window *m_PluginWindow;
	
	void AllocMem();
	void ClearLoops();
	
	Sample m_Databuf;	
	Sample m_CopyBuffer;
	
	Delay 	      m_Delay;
	DelayGUI      m_DelayGUI;
	Reverb 	      m_Reverb;
	ReverbGUI     m_ReverbGUI;
	ScopeGUI      m_Scope;
	Output 	      m_Out;
	OutputGUI     m_OutGUI;
	
	map<int,LoopWin*> m_LoopWinMap;
	float m_MasterLength;
	float m_MasterSpeed;
	float m_Magic;
	int   m_MasterLoopId;
	
	int   m_NextLoopId;
	
	// Main GUI stuff
	void CreateGUI(int xoff=0, int yoff=0, char *name="");
	Fl_Group 		*GUIMainGroup;	
	Fl_Button       *NewLoop;
	Fl_Button       *LoadPlugin;
	Fl_Button       *QuitPlugin;
	Fl_Button       *Load;
	Fl_Button       *Save;
	Fl_Knob         *SnapPoints;
	Fl_Button       *Snap;
	Fl_Value_Output *SnapOutput;
	
	void CheckTriggers();
	
	inline void cb_NewLoop_i(Fl_Button* o, void* v);
    static void cb_NewLoop(Fl_Button* o, void* v);
	inline void cb_LoadPlugin_i(Fl_Button* o, void* v);
    static void cb_LoadPlugin(Fl_Button* o, void* v);
	inline void cb_ClosePlugin_i(Fl_Button* o, void* v);
	static void cb_ClosePlugin(Fl_Button* o, void* v);
	inline void cb_Load_i(Fl_Button* o, void* v);
    static void cb_Load(Fl_Button* o, void* v);
	inline void cb_Save_i(Fl_Button* o, void* v);
    static void cb_Save(Fl_Button* o, void* v);
	inline void cb_SnapPoints_i(Fl_Knob* o, void* v);
    static void cb_SnapPoints(Fl_Knob* o, void* v);
	inline void cb_Snap_i(Fl_Button* o, void* v);
    static void cb_Snap(Fl_Button* o, void* v);
	
	friend istream &operator>>(istream &s, Loops &o);
	friend ostream &operator<<(ostream &s, Loops &o);	
};

istream &operator>>(istream &s, Loops &o);
ostream &operator<<(ostream &s, Loops &o);

#endif
