/*  SpiralSound
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <iostream.h>
#include <string>
#include <stdlib.h>
#include "Sample.h"

#ifndef SpiralINFO
#define SpiralINFO

// todo: better place for these util funcs
float RandFloat(float s=0.0f, float e=1.0f);

// Loads info from the resource file, overload and implement
// as singleton for each app. App specifc info may be added
// after the standard items.

class SpiralInfo
{
public:

    void LoadPrefs();
	void SavePrefs();
	
	static int    BUFSIZE;	
	static int    SAMPLERATE;
	static long   MAXSAMPLE;
	static float  VALUECONV;
	static bool   WANTMIDI;
	static int    FILTERGRAN;
	static string OUTPUTFILE;
	static string MIDIFILE;
	static bool   REALTIMEOUT;
	static int    POLY;
	
	static int   GUI_COLOUR;
	static int   GUIBG_COLOUR;
	static int   GUIBG2_COLOUR;		

	string GetHomeDir() {return m_HomeDir;}

protected:
	
	SpiralInfo() : m_HomeDir(getenv("HOME")) {}
	virtual ~SpiralInfo() {}

	virtual string GetResFileName() { return "ballsSpiralrc"; }
	
	virtual void StreamInPrefs(istream &s);
	virtual void StreamOutPrefs(ostream &s);
	
	string m_HomeDir;
};

#endif
