/*  SpiralLoops
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>

#include "SpiralSound/SpiralInfo.h"

float RandFloat(float s=0.0f, float e=1.0f)
{
	return s+((rand()%10000/10000.0)*(e-s));
}

int    SpiralInfo::BUFSIZE     = 512;	
int    SpiralInfo::SAMPLERATE  = 44100;
long   SpiralInfo::MAXSAMPLE   = 32767;
float  SpiralInfo::VALUECONV   = 1.0f/MAXSAMPLE;
bool   SpiralInfo::WANTMIDI    = true;
int    SpiralInfo::FILTERGRAN  = 50;
string SpiralInfo::OUTPUTFILE  = "/dev/dsp";
string SpiralInfo::MIDIFILE    = "/dev/midi";
int    SpiralInfo::POLY        = 2;
bool   SpiralInfo::REALTIMEOUT = true;
string SpiralInfo::KEYMAP("zsxdcvgbhnjmq2w3er5t6y7ui9o0p[");
int    SpiralInfo::NKEYS       = 30;

int SpiralInfo::GUI_COLOUR = 131;//179;
int SpiralInfo::GUIBG_COLOUR = 0;
int SpiralInfo::GUIBG2_COLOUR = 49;//45;

SpiralInfo* SpiralInfo::m_SpiralInfo=NULL;

SpiralInfo* SpiralInfo::Get()
{
	if (!m_SpiralInfo)
	{
		m_SpiralInfo = new SpiralInfo;
	}
	
	return m_SpiralInfo;
}

void SpiralInfo::LoadPrefs()
{
	string rcfn(m_HomeDir+"/.SpiralLoopsrc");
	ifstream i(rcfn.c_str());
	
	if (!i)
	{
		cerr<<".Spiralrc synth config file not found, creating default\n"<<endl;
		SavePrefs();
		return;
	}	
	
	char temp[256];
	
	i>>temp>>temp>>temp;
	
	i>>temp>>temp>>BUFSIZE;
	i>>temp>>temp>>SAMPLERATE;
	i>>temp>>temp>>WANTMIDI;
	i>>temp>>temp>>FILTERGRAN;
	i>>temp>>temp>>OUTPUTFILE;
	i>>temp>>temp>>MIDIFILE;
	i>>temp>>temp>>REALTIMEOUT;
	i>>temp>>temp>>KEYMAP;
	i>>temp>>temp>>POLY;
}

void SpiralInfo::SavePrefs()
{
	string rcfn(m_HomeDir+"/.SpiralLoopsrc");
	ofstream o(rcfn.c_str());
	
	o<<"SpiralLoops resource file"<<endl<<endl;
	o<<"BufferSize        = "<<BUFSIZE<<endl;	
	o<<"Samplerate        = "<<SAMPLERATE<<endl;
	o<<"WantMidi          = "<<WANTMIDI<<endl;
	o<<"FilterGranularity = "<<FILTERGRAN<<endl;
	o<<"Output            = "<<OUTPUTFILE<<endl;
	o<<"Midi              = "<<MIDIFILE<<endl;
	o<<"WantRealtimeOut   = "<<REALTIMEOUT<<endl;
	o<<"KeyMap            = "<<KEYMAP<<endl;
	o<<"Polyphony         = "<<POLY<<endl;
}	
