// Test rectangles some

#include "sdlmm_config.h"
RCSID("$Id: rect.cpp,v 1.10 2001/07/06 20:41:18 neotron Exp $");
#include "sdlmm.h"
#include <cstdio>

using SDLmm::SRect;
using SDLmm::SPoint;

int main(int argc, char *argv[])
{
  SRect r1(100, 100);
  SRect r2;
  SDL_Rect sdr = { 10, 20, 30, 40 };

  printf("r1:  x=%-3d y=%-3d w=%-3d h=%-3d\n", r1.x, r1.y, r1.w, r1.h);
  printf("r2:  x=%-3d y=%-3d w=%-3d h=%-3d\n", r2.x, r2.y, r2.w, r2.h);
  printf("sdr: x=%-3d y=%-3d w=%-3d h=%-3d\n\n", sdr.x, sdr.y, sdr.w, sdr.h);

  printf("Assigning r1 to r2 and sdr to r1...\n\n");

  r2 = r1; r1 = sdr;
  
  printf("r1:  x=%-3d y=%-3d w=%-3d h=%-3d\n", r1.x, r1.y, r1.w, r1.h);
  printf("r2:  x=%-3d y=%-3d w=%-3d h=%-3d\n\n", r2.x, r2.y, r2.w, r2.h);

  printf("r1 == sdr => %s\n", r1 == sdr ? "true": "false");
  printf("r1 == r2  => %s\n\n", r1 == r2 ? "true": "false");

  SPoint tmp = r1.GetUpperLeft();
  printf("r1 upper left pt:    x=%-3d y=%-3d\n", tmp.x, tmp.y); 
  tmp = r1.GetUpperRight();
  printf("r1 upper right pt:   x=%-3d y=%-3d\n", tmp.x, tmp.y);
  tmp = r1.GetBottomLeft();
  printf("r1 bottom left pt:   x=%-3d y=%-3d\n", tmp.x, tmp.y);
  tmp = r1.GetBottomRight();
  printf("r1 bottom right pt:  x=%-3d y=%-3d\n", tmp.x, tmp.y);

  r1 = SRect(SPoint(10,10), SPoint(20, 15));
  printf("r1:  x=%-3d y=%-3d w=%-3d h=%-3d\n", r1.x, r1.y, r1.w, r1.h);

#ifdef ASSERTIONS
  printf("There should be an assertion thrown next...\n");
#else
  printf("Since assertions is disabled, the rectangle below will be very wide.\n");
#endif

  r1 = SRect(SPoint(25,10), SPoint(20, 15));
  printf("r1:  x=%-3d y=%-3d w=%-3d h=%-3d\n", r1.x, r1.y, r1.w, r1.h);

  return 0;
}

