/////////////////////////////////////////////////////////////////////////////
//  P C 6 0 0 1 V
//  Copyright 1999 Yumitaro
/////////////////////////////////////////////////////////////////////////////
// ---------------------------------------------------------------------------
//	Virtual Bus Implementation
//	Copyright (c) cisc 1999.
// ---------------------------------------------------------------------------
//	$Id: device.cpp,v 1.21 2000/06/20 23:53:03 cisc Exp $

#include <stdexcept>

#include "device.h"


// --------------------------------------------------------------------------
// Device
// --------------------------------------------------------------------------
/////////////////////////////////////////////////////////////////////////////
// Constructor
/////////////////////////////////////////////////////////////////////////////
Device::Device( VM6* vm, const ID& id ) : vm( vm ), id( id )
{
}


/////////////////////////////////////////////////////////////////////////////
// Destructor
/////////////////////////////////////////////////////////////////////////////
Device::~Device( void )
{
}


/////////////////////////////////////////////////////////////////////////////
// DeviceID取得
/////////////////////////////////////////////////////////////////////////////
const Device::ID& Device::GetID( void ) const
{
	return id;
}


/////////////////////////////////////////////////////////////////////////////
// イベントコールバック関数
/////////////////////////////////////////////////////////////////////////////
void Device::EventCallback( int eid, int clk )
{
}




// --------------------------------------------------------------------------
// DeviceList
// --------------------------------------------------------------------------
/////////////////////////////////////////////////////////////////////////////
// Constructor
/////////////////////////////////////////////////////////////////////////////
DeviceList::DeviceList( void ) : dummydev( nullptr )
{
}


/////////////////////////////////////////////////////////////////////////////
// Destructor
/////////////////////////////////////////////////////////////////////////////
DeviceList::~DeviceList( void )
{
}


/////////////////////////////////////////////////////////////////////////////
// デバイス追加
/////////////////////////////////////////////////////////////////////////////
bool DeviceList::Add( const std::shared_ptr<IDevice>& t )
{
	ID id;
	Node n = { t, 0 };
	
	if( !n.entry || !(id = n.entry->GetID()) ){
		return false;
	}
	
	auto p = NodeMap.emplace( id, std::move( n ) );
	// p.first  : 要素へのイテレータ
	// p.second : true:新規挿入された false:すでに存在する
	p.first->second.count++;
	return true;
}


/////////////////////////////////////////////////////////////////////////////
// デバイス削除
/////////////////////////////////////////////////////////////////////////////
bool DeviceList::Del( const ID id )
{
	try{
		Node& n = NodeMap.at( id );
		if( !--n.count ){ NodeMap.erase( id ); }
		return true;
	}
	catch( std::out_of_range& ){
		return false;
	}
}


/////////////////////////////////////////////////////////////////////////////
// デバイス検索
/////////////////////////////////////////////////////////////////////////////
std::shared_ptr<IDevice>& DeviceList::Find( const ID id )
{
	try{
		Node& n = NodeMap.at( id );
		return n.entry;
	}
	catch( std::out_of_range& ){
		return dummydev;
	}
}
