<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

February 8, 2021

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Mei Chu (_TSC_) - Sony Pictures Imageworks
  * [ ] Sean Cooper (_TSC ACES TAC Rep_) - ARRI
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Mark Titchener (_TSC_) - Foundry
  * [ ] Carl Rand (_TSC_) - Weta Digital
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Rémi Achard - DNEG
  * [X] Thomas Mansencal - Weta Digital
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] J Schulte - Industrial Light & Magic

# **OCIO TSC Meeting Notes**

* Several pending pull requests: some are Python reviews, but most of them are 
  meeting minute reviews.
    - Patrick: Few PRs awaiting review. Not C++ changes - meeting minutes, 
      Python, etc.
    - Carol: There's a website PR ready for review too. I will take a look at 
      that.
    - Michael: Noting some issues reported related to v2, which means it's 
      being used and tested. I've been testing it and love the new config 
      features. Being able to build configs without external files is great.
    - Patrick: Doug and I are investigating the issues. Big thanks to Doug for
      the config improvements. *clap*
    - Kevin: Using pre-release of v2 and encountered a bug while baking to 
      Resolve cube with ociobakelut. Known issue? Asking to bake 3D cube, but 
      resulted in 1d cube. I will investigate further.

* GSoC/D&I internships:
    - Carol: Put doc in TSC channel. Two projects - ffmpeg support, and OFX 
      plugins:
      https://docs.google.com/document/d/1sa68Cjq0TzSYFg2xhf2w2FFAQ1In7G391iINWKXfDo8/edit?usp=sharing
    - Carol: Going to ask community for more ideas, and for more mentor 
      volunteers this week. End of this week needs to go to Larry. Think we're 
      the only ones submitting to GSoC this year.
    - Michael: Quick mention that there's a new ASWF working group forming 
      around topic of Rust bindings for VFX OSS libs. Sounds like a group of 
      developers interested in working on this for several projects. First need
      to make C bindings.
    - Mark B: Talked about OCIO C bindings a while ago. Complex due to use 
      of shared pointers everywhere.
    - Patrick: Earlier we discussed the idea of going back and making OCIO a C
      lib with header only C++ bindings. Too late now, but interesting topic.

* Static builds - cmake export:
    - Mark B: Problems with static builds when deploying on Windows. Looking at 
      fixing a number of CMake issues and improving 3rd party lib builds. 
      Improving debug and release builds too. PR will have a lot of changes, 
      but only to CMake. Hoping to open PR this week. Also noting some issues 
      with the way unit tests are linked which could be improved later. Tests 
      don't use same targets as lib, so must rebuild code.
    - Patrick: Unit tests need private part of some files, so needed in some 
      places. Even if CMake is platform agnostic, have to deal with Windows 
      specific stuff. Often seems slightly broken on Windows platform.
    - Mark: Big one for me was debug. CMake build type variable doesn't work on 
      all platforms. Default setup on Windows uses VS solutions, which support 
      multiple targets. Since on Windows release and debug libs can't be mixed, 
      current setup can be problematic.

* Locale issue:
    - Patrick: Working on OCIO v2 integration in Maya. Facing locale issue - 
      numeric separator handling. We discussed this earlier, but will need to 
      resume conversation.
    - Mark B: Parsing LUT files with locale wrong can cause read issues. 
      Probably want correct locale when reading yaml files, but one consistent 
      locale when reading LUTs.
    - Patrick: Previous Turkish locale bug was related to upper to lower case 
      conversion (PR #984). I agree that numeric parsing should be locked to 
      decimal points.
    - Doug: Lib is quite dependent on lowercase conversions. Could argue not 
      needed, but for backward compatibility might have to keep it.

* Items for next TSC meeting agenda:
    - Absent next week: Patrick, Michael. Doug will be present and host.
