<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

April 29, 2019

Host: Michael Dolan

Rotating Secretary: Michael Dolan

Attendees:
  * [ ] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [ ] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Sony Pictures Imageworks
  * [X] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [X] John Mertic - Academy Software Foundation / Linux Foundation
  * [ ] Carl Rand (_TSC_) - Foundry
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [ ] Kevin Wheatley (_TSC_) - Framestore

Apologies:
  * Sean Cooper (_TSC_) - DNEG
  * Kevin Wheatley (_TSC_) - Framestore

# **OCIO TSC Meeting Notes**

* CLA/DSO System
    - Doug: Wiki and website need more explanation of what to do (i.e. clear
      steps to follow).
    - John: There are two links:
        - Wiki with info about what to do
        - CLA console where signature and contributors are managed
    - Doug: No problem with having two separate websites.
        - Wiki has a lot of detailed info for someone already in the system, as
          reference.
        - Confused about what to send to executives/lawyers about what to do.
          Having more concrete steps would be helpful.
    - John: Multiple roles may be needed:
        - Signatory: Name on CLA, who does sign off.
        - CLA Manager: Person in organization that manages individual
          contributors who are covered by the CLA.
        - The manager is the one who enters names and maintains the system.
        - Agrees the process is less than intuitive.
    - John: Suggests a demo of the system from the LF product team.
    - All: Agree a demo would be good.
    - The demo could make sense to do at a TAC meeting, or just have a video,
      but John suggests we do something in-person for now to unblock OCIO.
    - Doug: On the create account website, it says only one account can be
      created for an organization; not one per project. A CLA manager would
      need to be someone at a corporate level, or of a parent organization.
    - John: There can be a different manager and signatory for flexibility. The
      manager can designate who can manage contributors. No need to get
      corporate council involved to add someone.
    - **TODO**: Schedule CLA system demo from LF product team.

* SonarCloud Static Analysis
    - Michael: Working on SonarCloud integration for Travis.
        - Can't test from an external (forked) PR, so need a better way to test.
        - Larry: You can create a dedicated testing branch and push changes to
          that directly. That avoids PRs for testing and is internal to GH.
        - Michael: Good idea. I'll do that for initial testing.
    - Patrick: Does analysis break the build? Where do we see results?
        - We need to know when something critical breaks, without having to
          remember to check SonarCloud site.
    - Michael: Results are on Imageworks SonarCloud account for now. PR #740
      has a link.
        - sonar-scanner returns non-0 exit if quality gate is not met, so will
          break the build.
        - There is a SonarCloud badge, which will tell you if the last analysis
          is passing or failing. That will also link to full results.
        - Needs testing once it is up and running to see how we should
          configure it.

* OSX CI Configurations
    - Michael: Noticed that our OSX GCC build is actually a duplicate of the
      Clang build. To use GCC, we have to set it up differently, since macOS
      treats gcc as an alias to clang.
    - Larry: Do we need a Mac GCC build? We have Linux GCC builds which should
      catch he same errors and warnings.
    - Michael: Perhaps instead we can have multiple OSX Clang builds with
      different OS versions: older and newer?
    - Patrick/Doug: Agree that is reasonable.
    - Larry: Good to test with variety of OS versions to catch more issues.
    - **TODO**: Michael will reconfigure the OSX test matrix.

* LF CommunityBridge
    - Michael: Since this is an official LF tool, and has security vulnerability
      reporting, should we consider it instead of our current email approach?
    - John: We should stay where we are for now. We need more data on
      CommunityBridge, since it is new.

* OCIO V2 Working Group
    - Doug: V2 working group is tomorrow (April 30), 3pm EST.
    - Michael: Will you be opening new PRs today or tomorrow for discussion?
    - Doug: Will be opening PRs this week, and a GH issue today on one topic.
        - Issue (for discussion) will be regarding new OCIO display transforms.
    - Doug/Patrick: New PRs coming involve CPU renderer with bit-depth support
      and API, etc.

* Items for next TSC meeting agenda:
    - Kevin mentioned in his apology that he had a topic, but will bring it up
      at the next meeting.
