/*
 * Copyright (c) 2009 Nhat Minh Lê <nhat.minh.le@huoc.org>
 *
 * Permission to use, copy, modify, and/or distribute this software
 * for any purpose with or without fee is hereby granted, provided
 * that the above copyright notice and this permission notice appear
 * in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Simple geometrically-growing NUL-terminated string buffer
 * implementation. These buffers always end with an extra '\0' (even
 * when using regxml_buffer_appendraw()).
 */

#ifndef REGXML_BUFFER_H
#define REGXML_BUFFER_H

#include <sys/cdefs.h>

#include <stddef.h>		/* For size_t. */

struct regxml_buffer {
	char *rxb_base;
	size_t rxb_index, rxb_size;
};

__BEGIN_DECLS
int regxml_buffer_init(struct regxml_buffer *, size_t);
void regxml_buffer_free(struct regxml_buffer *);
int regxml_buffer_appendraw(struct regxml_buffer *, const char *, size_t);
int regxml_buffer_append(struct regxml_buffer *, const char *);
int regxml_buffer_strdup(struct regxml_buffer *, char **);
__END_DECLS

#endif	/* !REGXML_BUFFER_H */
