.TH GRDTRACK l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
grdtrack \- Sampling of a 2-D grdfile along 1-D trackline (a sequence of x,y points)
.SH SYNOPSIS
\fBgrdtrack\fP \fIxyfile\fP \fB\-G\fP\fIgrdfile\fP [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-L\fP\fIflag\fP ] [ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] 
[ \fB\-Q\fP[\fIvalue\fP] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-S\fP ] [ \fB\-V\fP ] [ \fB\-Z\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] 
[ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] [ \fB\-f\fP[\fBi\fP|\fBo\fP]\fIcolinfo\fP ]
.SH DESCRIPTION
\fBgrdtrack\fP reads a grdfile (or a Sandwell/Smith IMG file) and a table (from file or standard input) with (x,y) positions 
in the first two columns (more columns may be present). It interpolates the grid at the positions 
in the table and writes out the table with the interpolated values added as a new column.  A bicubic 
[Default] or bilinear [\fB\-Q\fP] interpolation is used, requiring boundary conditions at the limits 
of the region (see \fB\-L\fP).
.TP
\fIxyfile\fP
This is an ASCII [or binary, see \fB\-b\fP] file where the first 2 columns hold the (x,y) positions where the user wants to sample
the 2-D data set.
.TP
.B \-G
\fIgrdfile\fP is a 2-D binary grd file with the function f(x,y).
If the specified grid is in Sandwell/Smith Mercator format you must append a comma-separated list of
arguments that includes a scale to multiply the data (usually 1 or 0.1), the mode which stand for the following:
(0) Img files with no constraint code, returns data at all points, (1) Img file with constraints coded,
return data at all points, (2) Img file with constraints coded, return data only at constrained points
and NaN elsewhere, and (3) Img file with constraints coded, return 1 at constraints and 0 elsewhere,
and optionally the max latitude in the IMG file [72.0059773539].
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-L
Boundary condition \fIflag\fP may be \fIx\fP or \fIy\fP or \fIxy\fP indicating data is periodic in range of 
x or y or both set by \fB\-R\fP, or \fIflag\fP may be \fIg\fP indicating geographical conditions (x and y are 
lon and lat).  [Default uses "natural" conditions (second partial derivative normal to edge is zero).]
.TP
.B \-M
Multiple segment file.  Segment separator is a record beginning with \fIflag\fP.
[Default is '>'].
.TP
.B \-Q
Quick mode, use bilinear rather than bicubic interpolation [Default].  Optionally, append \fIvalue\fP in the
0 <= \fIvalue\fP <= 1 range.  This parameter controls how close to nodes with NaN values the
interpolation will go.  E.g., a \fIvalue\fP of 0.5 will interpolate about 1/2-way from a non-NaN to a
NaN node, whereas 0.1 will go about 90% of the way, etc. [Default is 1, which means none of the four nearby
nodes may be NaN].  A \fIvalue\fP of 0 will just return the value of the nearest node instead of interpolating.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.TP
.B \-S
Suppress the output of interpolated points that result in NaN values.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-Z
Only write out the sampled z-values [Default writes all columns].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is one more than input].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH HINTS
If an interpolation point is not on a node of the input grid, then a NaN at any node in the neighborhood 
surrounding the point will yield an interpolated NaN.  Bicubic interpolation [default] yields continuous 
first derivatives but requires a neighborhood of 4 nodes by 4 nodes.  Bilinear interpolation [\fB\-Q\fP] 
uses only a 2 by 2 neighborhood, but yields only zeroth-order continuity.  Use bicubic when smoothness is 
important.  Use bilinear to minimize the propagation of NaNs.
.SH EXAMPLES
To sample the file hawaii_topo.grd along the SEASAT track track_4.xyg (An ASCII
table containing longitude, latitude, and SEASAT-derived gravity, preceded by one header record):
.br
.sp
\fBgrdtrack\fP track_4.xyg \fB\-G\fPhawaii_topo.grd \fB\-H\fP > track_4.xygt
.br
.sp
To sample the Sandwell/Smith IMG format file topo.8.2.img (2 minute predicted bathymetry on a Mercator
grid) along the lon,lat coordinates given in the file cruise_track.xy, try
.br
.sp
\fBgrdtrack\fP cruise_track.xy \fB\-G\fPtopo.8.2.img,1,1 > obs_and_predicted.d
.SH "SEE ALSO"
.IR GMT (l),
.IR surface (l),
.IR sample1d (l)
