# $Id: dep.mk,v 1.12 2007/11/22 19:02:15 sjg Exp $

.if !target(__${.PARSEFILE}__)
__${.PARSEFILE}__:

# handle Proc*C as well...
.if defined(SRCS)
.if !empty(SRCS:M*.pc)
.include "proc.mk"
.endif
.endif

.if exists(/usr/bin/mkdep)
MKDEP?=	mkdep
.elif exists(/usr/local/share/bin/mkdeps.sh)
MKDEP?=	/usr/local/share/bin/mkdeps.sh -N
.endif
MKDEP?=	mkdep

.NOPATH:	.depend

.ifdef NO_AUTODEP
USE_AUTODEP_MK=no
.endif
USE_AUTODEP_MK?=yes
.if ${USE_AUTODEP_MK:tl} == yes
.include "autodep.mk"
.else
# some of the rules involve .h sources, so remove them from mkdep line
.if !target(depend)
depend: beforedepend .depend _SUBDIRUSE afterdepend
.if defined(SRCS)
# libs can have too many SRCS for a single command line
# so do them on at a time.
.depend: ${SRCS}
	@rm -f .depend
.ifdef LIB
	@files="${.ALLSRC:M*.[sS]}"; \
	if [ "$$files" != " " ]; then \
	  set -x; for f in $$files; do ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CFLAGS:M-[ID]*} ${CPPFLAGS} ${AINC} $$f; done; \
	fi
	@files="${.ALLSRC:M*.c} ${.ALLSRC:M*.pc:T:.pc=.c}"; \
	if [ "$$files" != "" ]; then \
	  set -x; for f in $$files; do ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CFLAGS:M-[ID]*} ${CPPFLAGS} $$f; done; \
	fi
	@files="${.ALLSRC:M*.cc} ${.ALLSRC:M*.C} ${.ALLSRC:M*.cxx}"; \
	if [ "$$files" != "  " ]; then \
	  set -x; for f in $$files; do ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CXXFLAGS:M-[ID]*} ${CPPFLAGS} $$f; done; \
	fi
.else
	@files="${.ALLSRC:M*.[Ss]}"; \
	if [ "$$files" != " " ]; then \
	  echo ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CFLAGS:M-[ID]*} ${CPPFLAGS} ${AINC} $$files; \
	  ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CFLAGS:M-[ID]*} ${CPPFLAGS} ${AINC} $$files; \
	fi
	@files="${.ALLSRC:M*.c} ${.ALLSRC:M*.pc:T:.pc=.c}"; \
	if [ "$$files" != "" ]; then \
	  echo ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CFLAGS:M-[ID]*} ${CPPFLAGS} $$files; \
	  ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CFLAGS:M-[ID]*} ${CPPFLAGS} $$files; \
	fi
	@files="${.ALLSRC:M*.cc} ${.ALLSRC:M*.C} ${.ALLSRC:M*.cxx}"; \
	if [ "$$files" != "  " ]; then \
	  echo ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CXXFLAGS:M-[ID]*} ${CPPFLAGS} $$files; \
	  ${MKDEP} -a ${MKDEPFLAGS} \
	    ${CXXFLAGS:M-[ID]*} ${CPPFLAGS} $$files; \
	fi
.endif
.else
.depend:
.endif
.if !target(beforedepend)
beforedepend:
.endif
.if !target(afterdepend)
afterdepend:
.endif
.endif
.endif

.if !target(tags)
.if defined(SRCS)
tags: ${SRCS} _SUBDIRUSE
	-cd ${.CURDIR}; ctags -f /dev/stdout ${.ALLSRC:N*.h} | \
	    sed "s;\${.CURDIR}/;;" > tags
.else
tags:
.endif
.endif

.if defined(SRCS)
cleandir: cleandepend
.if !target(cleandepend)
cleandepend:
	rm -f .depend ${.CURDIR}/tags
.endif
.endif

.endif
