#include <sys/param.h>
#include <sys/event.h>
#include <sys/time.h>

#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int
main(int argc, char **argv)
{
	struct timespec		timeout;
	struct timeval		then, now, diff;
	struct kfilter_mapping	km;
	struct kevent		event[1];
	int	kq, n;
	pid_t	pid;

	pid = getpid();
	printf("my pid: %d\n", pid);

        kq = kqueue();
        if (kq == -1)
                err(1, "kqueue");
	km.name = "EVFILT_SIGNAL";
	if (ioctl(kq, KFILTER_BYNAME, &km) == -1)
		err(1, "KFILTER_BYNAME `%s'", km.name);
	else
		printf("got %d as filter number for `%s'.\n",
		    km.filter, km.name);

	event[0].ident = SIGCHLD;
	event[0].filter = km.filter;
	event[0].flags = EV_ADD | EV_ENABLE;
	n = kevent(kq, event, 1, NULL, 0, NULL);
	if (n == -1)
		err(1, "kevent(1)");

	sleep(10);

	timeout.tv_sec = 10;
	timeout.tv_nsec = 0;

	for (;;) {
		if (gettimeofday(&then, NULL) == -1)
			err(1, "gettimeofday then");
		n = kevent(kq, NULL, 0, event, 1, &timeout);
		if (gettimeofday(&now, NULL) == -1)
			err(1, "gettimeofday now");
		timersub(&now, &then, &diff);
		printf("kevent returned %d in %ld.%06ld\n", n,
		    diff.tv_sec, diff.tv_usec);
		if (n == -1)
			err(1, "kevent(2)");
		else if (n == 0)
			continue;
		printf(
		    "kevent flags: 0x%x, data: %ld (# times signal posted)\n",
		    event[0].flags, event[0].data);
	}
}
