#include <sys/param.h>
#include <sys/event.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <netinet/in.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

void	dumpkevent(struct kevent *);

void
dumpkevent(struct kevent *event)
{
	printf(
"kevent: ident 0x%02lx filter %d flags: 0x%02x, fflags: 0x%02x, data 0x%lx\n",
	    event->ident, event->filter, event->flags, event->fflags,
	    event->data);
}


int
main(int argc, char **argv)
{
	struct timespec		timeout;
	struct timeval		then, now, diff;
	struct kevent		event[5];
	struct sockaddr_in	sa;
	int			kq, fd, n, i, match, count;
	char			buffer[128];

	if (argc != 2)
		errx(1, "Usage: %s port", argv[0]);

        kq = kqueue();
        if (kq == -1)
                err(1, "kqueue");
	
	fd = socket(PF_INET, SOCK_STREAM, 0);
	if (fd == -1)
		err(1, "socket");
	memset((void *)&sa, 0, sizeof(sa));

	sa.sin_family = AF_INET;
	sa.sin_port = htons(atoi(argv[1]));
	sa.sin_addr.s_addr = htonl(0x7f000001);
	if (connect(fd, (struct sockaddr *)&sa, sizeof(sa)) == -1)
		err(1, "connect");

	n = sizeof(sa);

	EV_SET(&event[0], fd, EVFILT_WRITE, EV_ADD | EV_ENABLE, 0, NULL, NULL);
	n = kevent(kq, event, 1, NULL, 0, NULL);
	if (n == -1)
		err(1, "kevent(1)");
printf("registered fd %d\n", fd);
	
		/*
		 * start writing
		 */
	count = 0;
	for (;;) {
		if (gettimeofday(&then, NULL) == -1)
			err(1, "gettimeofday then");
		n = kevent(kq, NULL, 0, event, 5, &timeout);
		if (gettimeofday(&now, NULL) == -1)
			err(1, "gettimeofday now");
		timersub(&now, &then, &diff);

		printf("kevent returned %d in %ld.%06ld\n", n,
		    diff.tv_sec, diff.tv_usec);
		if (n == -1)
			err(1, "kevent");
		else if (n == 0)
			continue;

		match = -1;
		for (i = 0; i < n; i++) {
			printf("event[%d]: ", i);
			dumpkevent(&event[i]);
			if (event[i].ident == fd)
				match = i;
		}
printf("match is %d\n", match); sleep(1);
		if (match == -1)
			continue;

		i = snprintf(buffer, sizeof(buffer),
		    "|----> count %d <------------------------------------------------------------------------------------------------------------------------------------------|\n", count++);
		n = write(fd, buffer, i);
		if (event[match].flags & EV_ERROR) {
			printf("error received: %d %m\n",
			    (int)event[match].data,
			    strerror((int)event[match].data));
			break;
		} else if (event[match].flags & EV_EOF) {
			printf("EOF received\n");
			break;
		}
	}
	return (0);
}
