/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.sonatype.nexus.staging.api.dto.StagingActionDTO;
import com.sonatype.nexus.staging.api.dto.StagingActivityDTO;
import com.sonatype.nexus.staging.api.dto.StagingActivityEventDTO;
import com.sonatype.nexus.staging.api.dto.StagingProfileRepositoryDTO;
import com.sonatype.nexus.staging.api.dto.StagingPropertyDTO;
import com.sonatype.nexus.staging.client.StagingRepository;
import com.sonatype.nexus.staging.client.StagingRuleFailures;
import com.sonatype.nexus.staging.client.StagingRuleFailuresException;
import com.sonatype.nexus.staging.client.StagingWorkflowV3Service;
import com.sonatype.nexus.staging.client.internal.ExceptionConverter;
import com.sonatype.nexus.staging.client.internal.StagingWorkflowV2ServiceImpl;
import com.sonatype.nexus.staging.client.internal.TransitioningListener;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class StagingWorkflowV3ServiceImpl
extends StagingWorkflowV2ServiceImpl
implements StagingWorkflowV3Service {
    private final StagingWorkflowV3Service.ProgressMonitor defaultProgressMonitor;
    private StagingWorkflowV3Service.ProgressMonitor progressMonitor;
    private int progressTimeoutMinutes;
    private int progressPauseDurationSeconds;
    private static final String RULE_FAILED_EVENT_NAME = "ruleFailed";

    public StagingWorkflowV3ServiceImpl(JerseyNexusClient nexusClient) {
        super(nexusClient);
        this.progressMonitor = this.defaultProgressMonitor = new StagingWorkflowV3Service.ProgressMonitor(){

            private void println(String message) {
                StagingWorkflowV3ServiceImpl.this.log.trace(message);
            }

            @Override
            public void start() {
                this.println("START");
            }

            @Override
            public void tick() {
                this.println("TICK");
            }

            @Override
            public void info(String message) {
                this.println("INFO: " + message);
            }

            @Override
            public void error(String message) {
                this.println("ERROR: " + message);
            }

            @Override
            public void pause() {
                this.println("PAUSE");
            }

            @Override
            public void stop() {
                this.println("STOP");
            }

            @Override
            public void timeout() {
                this.println("TIMEOUT");
            }

            @Override
            public void interrupted() {
                this.println("INTERRUPTED");
            }
        };
        this.progressTimeoutMinutes = 5;
        this.progressPauseDurationSeconds = 3;
    }

    @Override
    protected StagingRepository.State stateOf(StagingProfileRepositoryDTO repository) {
        String type = repository.getType();
        if ("released".equals(type)) {
            return StagingRepository.State.RELEASED;
        }
        return super.stateOf(repository);
    }

    @Override
    @Nullable
    public StagingProfileRepositoryDTO findRepository(final String repositoryId) {
        return (StagingProfileRepositoryDTO)new ExceptionConverter<StagingProfileRepositoryDTO>((StagingWorkflowV2ServiceImpl)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public StagingProfileRepositoryDTO perform() {
                ClientResponse response = (ClientResponse)((JerseyNexusClient)StagingWorkflowV3ServiceImpl.this.getNexusClient()).serviceResource("staging/repository/" + repositoryId).get(ClientResponse.class);
                try {
                    if (response.getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
                        StagingProfileRepositoryDTO stagingProfileRepositoryDTO = null;
                        return stagingProfileRepositoryDTO;
                    }
                    StagingProfileRepositoryDTO stagingProfileRepositoryDTO = (StagingProfileRepositoryDTO)response.getEntity(StagingProfileRepositoryDTO.class);
                    return stagingProfileRepositoryDTO;
                }
                finally {
                    response.close();
                }
            }
        }.runAndReturn();
    }

    @Override
    public void releaseStagingRepositories(StagingActionDTO action) {
        super.releaseStagingRepositories(action);
    }

    @Override
    public void setProgressMonitor(StagingWorkflowV3Service.ProgressMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor);
        this.progressMonitor = monitor;
    }

    @Override
    public void resetProgressMonitor() {
        this.setProgressMonitor(this.defaultProgressMonitor);
    }

    @Override
    public void setProgressTimeoutMinutes(int minutes) {
        this.progressTimeoutMinutes = minutes;
    }

    @Override
    public void setProgressPauseDurationSeconds(int seconds) {
        Preconditions.checkArgument((seconds >= 1 ? 1 : 0) != 0);
        this.progressPauseDurationSeconds = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void monitorRepositoryTransition(TransitioningListener collector, String ... repositoryIds) {
        ArrayList watching = Lists.newArrayList((Object[])repositoryIds);
        this.log.debug("Monitoring transition of repositories: {}", (Object[])repositoryIds);
        Stopwatch watch = new Stopwatch();
        watch.start();
        this.progressMonitor.start();
        try {
            ArrayList failures = Lists.newArrayList();
            while (!watching.isEmpty()) {
                Iterator iter = watching.iterator();
                while (iter.hasNext()) {
                    this.progressMonitor.tick();
                    if (watch.elapsed(TimeUnit.MINUTES) >= (long)this.progressTimeoutMinutes) {
                        this.log.debug("Progress has timed out after: {}", (Object)watch);
                        this.progressMonitor.timeout();
                        throw new StagingRuleFailuresException(500, "Progress has timed-out", failures, "");
                    }
                    String repositoryId = (String)iter.next();
                    this.log.debug("Checking repository: {}", (Object)repositoryId);
                    StagingProfileRepositoryDTO repository = this.findRepository(repositoryId);
                    this.log.trace("Repository: {}", (Object)repository);
                    if (repository == null) {
                        this.log.debug("Repository was removed; stop watching it");
                        iter.remove();
                        if (collector != null) {
                            collector.onRemoved(repositoryId);
                        }
                        this.progressMonitor.info(repositoryId + " REMOVED");
                        continue;
                    }
                    if (repository.isTransitioning()) continue;
                    iter.remove();
                    int notificationCount = repository.getNotifications();
                    this.log.debug("Repository is no longer in transition; notifications: {}", (Object)notificationCount);
                    if (notificationCount != 0) {
                        this.progressMonitor.error(repositoryId + " FAILED");
                        StagingRuleFailures stagingRuleFailures = this.collectRepositoryTransitionFailures(repository);
                        if (collector != null) {
                            collector.onTransitionedUnsuccessfully(repositoryId, repository, stagingRuleFailures);
                        }
                        failures.add(stagingRuleFailures);
                        continue;
                    }
                    this.progressMonitor.info(repositoryId + " OK");
                    if (collector == null) continue;
                    collector.onTransitionedSuccessfully(repositoryId, repository);
                }
                if (watching.isEmpty()) continue;
                this.progressMonitor.pause();
                try {
                    Thread.sleep(this.progressPauseDurationSeconds * 1000);
                }
                catch (InterruptedException e) {
                    this.log.debug("Progress interrupted");
                    this.progressMonitor.interrupted();
                    throw new StagingRuleFailuresException(500, "Progress interrupted", failures, "");
                }
            }
            if (!failures.isEmpty()) {
                throw new StagingRuleFailuresException(500, "Progress has failed with one or more errors", failures, "");
            }
        }
        finally {
            this.progressMonitor.stop();
            watch.stop();
        }
    }

    private StagingRuleFailures collectRepositoryTransitionFailures(StagingProfileRepositoryDTO repository) {
        ArrayList failures = Lists.newArrayList();
        this.log.debug("Fetching activity for repository: {}", (Object)repository.getRepositoryId());
        ClientResponse response = (ClientResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(String.format("staging/repository/%s/activity", repository.getRepositoryId())).get(ClientResponse.class);
        Preconditions.checkState((response.getClientResponseStatus() != ClientResponse.Status.NOT_FOUND ? 1 : 0) != 0);
        List activity = (List)response.getEntity((GenericType)new GenericType<List<StagingActivityDTO>>(){});
        Preconditions.checkNotNull((Object)activity);
        Preconditions.checkState((!activity.isEmpty() ? 1 : 0) != 0);
        StagingActivityDTO latest = (StagingActivityDTO)activity.get(activity.size() - 1);
        int notificationCount = 0;
        for (StagingActivityEventDTO event : latest.getEvents()) {
            if (event.getSeverity() != 0) {
                ++notificationCount;
            }
            if (!RULE_FAILED_EVENT_NAME.equals(event.getName())) continue;
            failures.add(new StagingRuleFailures.RuleFailure(this.getActivityEventValue(event, "typeId"), this.getActivityEventValues(event, "failureMessage")));
        }
        if (failures.isEmpty() && notificationCount > 0) {
            failures.add(new StagingRuleFailures.RuleFailure("operation-failed", Lists.newArrayList((Object[])new String[]{String.format("Operation has failed; repository has %d activity notifications", notificationCount)})));
        }
        return new StagingRuleFailures(repository.getRepositoryId(), failures);
    }

    private String getActivityEventValue(StagingActivityEventDTO event, String name) {
        for (StagingPropertyDTO property : event.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property.getValue();
        }
        return null;
    }

    private List<String> getActivityEventValues(StagingActivityEventDTO event, String name) {
        ArrayList values = Lists.newArrayList();
        for (StagingPropertyDTO property : event.getProperties()) {
            if (!name.equals(property.getName())) continue;
            values.add(property.getValue());
        }
        return values;
    }
}

