/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import org.sonatype.nexus.client.core.subsystem.repository.ProxyRepository;
import org.sonatype.nexus.client.core.subsystem.repository.ProxyRepositoryStatus;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyRepository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.ProxyRepositoryStatusImpl;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;
import org.sonatype.nexus.rest.model.RepositoryResourceRemoteStorage;
import org.sonatype.nexus.rest.model.RepositoryStatusResource;

public class JerseyProxyRepository<T extends ProxyRepository>
extends JerseyRepository<T, RepositoryProxyResource, ProxyRepositoryStatus>
implements ProxyRepository<T> {
    static final String REPO_TYPE = "proxy";
    static final String PROVIDER_ROLE = "org.sonatype.nexus.proxy.repository.Repository";

    public JerseyProxyRepository(JerseyNexusClient nexusClient, String id) {
        super(nexusClient, id);
    }

    public JerseyProxyRepository(JerseyNexusClient nexusClient, RepositoryProxyResource settings) {
        super(nexusClient, settings);
    }

    @Override
    protected RepositoryProxyResource createSettings() {
        RepositoryProxyResource settings = new RepositoryProxyResource();
        settings.setRepoType(REPO_TYPE);
        settings.setProviderRole(PROVIDER_ROLE);
        settings.setExposed(true);
        settings.setWritePolicy("READ_ONLY");
        settings.setBrowseable(true);
        settings.setIndexable(false);
        settings.setNotFoundCacheTTL(1440);
        settings.setRepoPolicy("MIXED");
        settings.setChecksumPolicy("WARN");
        settings.setDownloadRemoteIndexes(true);
        settings.setFileTypeValidation(true);
        settings.setArtifactMaxAge(-1);
        settings.setMetadataMaxAge(1440);
        settings.setItemMaxAge(Integer.valueOf(1440));
        settings.setAutoBlockActive(true);
        return settings;
    }

    private T me() {
        return (T)this;
    }

    @Override
    ProxyRepositoryStatus convertStatus(RepositoryStatusResource status) {
        if (status == null) {
            return new ProxyRepositoryStatusImpl(false, false, false);
        }
        return new ProxyRepositoryStatusImpl("IN_SERVICE".equals(status.getLocalStatus()), !"ALLOW".equals(status.getProxyMode()), "BLOCKED_AUTO".equals(status.getProxyMode()));
    }

    @Override
    public String proxyUri() {
        RepositoryResourceRemoteStorage remoteStorage = ((RepositoryProxyResource)this.settings()).getRemoteStorage();
        if (remoteStorage == null) {
            return null;
        }
        return remoteStorage.getRemoteStorageUrl();
    }

    @Override
    public T withRepoPolicy(String policy) {
        ((RepositoryProxyResource)this.settings()).setRepoPolicy(policy);
        return this.me();
    }

    @Override
    public T asProxyOf(String remoteUri) {
        RepositoryResourceRemoteStorage remoteStorage = ((RepositoryProxyResource)this.settings()).getRemoteStorage();
        if (remoteStorage == null) {
            remoteStorage = new RepositoryResourceRemoteStorage();
            ((RepositoryProxyResource)this.settings()).setRemoteStorage(remoteStorage);
        }
        remoteStorage.setRemoteStorageUrl(remoteUri);
        return this.me();
    }

    @Override
    public T withNotFoundCacheTTL(int minutes) {
        ((RepositoryProxyResource)this.settings()).setNotFoundCacheTTL(minutes);
        return this.me();
    }

    @Override
    public T withItemMaxAge(int minutes) {
        ((RepositoryProxyResource)this.settings()).setItemMaxAge(Integer.valueOf(minutes));
        return this.me();
    }

    @Override
    public int itemMaxAge() {
        return ((RepositoryProxyResource)this.settings()).getItemMaxAge();
    }

    @Override
    public T autoBlock() {
        ((RepositoryProxyResource)this.settings()).setAutoBlockActive(true);
        return this.me();
    }

    @Override
    public T doNotAutoBlock() {
        ((RepositoryProxyResource)this.settings()).setAutoBlockActive(false);
        return this.me();
    }

    @Override
    public boolean isAutoBlocking() {
        return ((RepositoryProxyResource)this.settings()).isAutoBlockActive();
    }

    @Override
    public T block() {
        RepositoryStatusResource newStatus = this.doGetStatus();
        newStatus.setProxyMode("BLOCKED_MANUAL");
        this.doUpdateStatus(newStatus);
        return this.me();
    }

    @Override
    public T unblock() {
        RepositoryStatusResource newStatus = this.doGetStatus();
        newStatus.setProxyMode("ALLOW");
        this.doUpdateStatus(newStatus);
        return this.me();
    }

    @Override
    public T enableBrowsing() {
        ((RepositoryProxyResource)this.settings()).setBrowseable(true);
        return this.me();
    }

    @Override
    public T disableBrowsing() {
        ((RepositoryProxyResource)this.settings()).setBrowseable(false);
        return this.me();
    }

    @Override
    public boolean isBrowsable() {
        return ((RepositoryProxyResource)this.settings()).isBrowseable();
    }
}

