/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.net.URL;
import org.apache.maven.plugins.assembly.io.Location;
import org.apache.maven.plugins.assembly.io.LocatorStrategy;
import org.apache.maven.plugins.assembly.io.MessageHolder;
import org.apache.maven.plugins.assembly.io.URLLocation;

class ClasspathResourceLocatorStrategy
implements LocatorStrategy {
    ClasspathResourceLocatorStrategy() {
    }

    @Override
    public Location resolve(String locationSpecification, MessageHolder messageHolder) {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        URL resource = cloader.getResource(locationSpecification);
        URLLocation location = null;
        if (resource != null) {
            location = new URLLocation(resource, locationSpecification, "location.", ".cpurl", true);
        } else {
            messageHolder.addMessage("Failed to resolve classpath resource: " + locationSpecification + " from classloader: " + cloader);
        }
        return location;
    }
}

