/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.phase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugins.assembly.archive.phase.PhaseOrder;
import org.apache.maven.plugins.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugins.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugins.assembly.archive.task.AddFileSetsTask;
import org.apache.maven.plugins.assembly.artifact.DependencyResolutionException;
import org.apache.maven.plugins.assembly.artifact.DependencyResolver;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.functions.MavenProjects;
import org.apache.maven.plugins.assembly.functions.ModuleSetConsumer;
import org.apache.maven.plugins.assembly.model.Assemblies;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.FileSet;
import org.apache.maven.plugins.assembly.model.ModuleBinaries;
import org.apache.maven.plugins.assembly.model.ModuleSet;
import org.apache.maven.plugins.assembly.model.ModuleSources;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.FilterUtils;
import org.apache.maven.plugins.assembly.utils.ProjectUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="module-sets")
public class ModuleSetAssemblyPhase
implements AssemblyArchiverPhase,
PhaseOrder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleSetAssemblyPhase.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final ProjectBuilder projectBuilder;
    private final DependencyResolver dependencyResolver;

    @Inject
    public ModuleSetAssemblyPhase(ProjectBuilder projectBuilder, DependencyResolver dependencyResolver) {
        this.projectBuilder = Objects.requireNonNull(projectBuilder);
        this.dependencyResolver = Objects.requireNonNull(dependencyResolver);
    }

    public static List<DependencySet> getDependencySets(ModuleBinaries binaries) {
        List<DependencySet> depSets = binaries.getDependencySets();
        if ((depSets == null || depSets.isEmpty()) && binaries.isIncludeDependencies()) {
            DependencySet impliedDependencySet = new DependencySet();
            impliedDependencySet.setOutputDirectory(binaries.getOutputDirectory());
            impliedDependencySet.setFileMode(binaries.getFileMode());
            impliedDependencySet.setDirectoryMode(binaries.getDirectoryMode());
            impliedDependencySet.setExcludes(binaries.getExcludes());
            impliedDependencySet.setIncludes(binaries.getIncludes());
            impliedDependencySet.setUnpack(binaries.isUnpack());
            depSets = Collections.singletonList(impliedDependencySet);
        }
        return depSets;
    }

    public static Set<MavenProject> getModuleProjects(ModuleSet moduleSet, AssemblerConfigurationSource configSource, Logger logger) throws ArchiveCreationException {
        MavenProject project = configSource.getProject();
        Set<MavenProject> moduleProjects = null;
        if (moduleSet.isUseAllReactorProjects()) {
            if (!moduleSet.isIncludeSubModules()) {
                moduleProjects = new LinkedHashSet<MavenProject>(configSource.getReactorProjects());
            }
            project = configSource.getReactorProjects().get(0);
        }
        if (moduleProjects == null) {
            try {
                moduleProjects = ProjectUtils.getProjectModules(project, configSource.getReactorProjects(), moduleSet.isIncludeSubModules(), logger);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error retrieving module-set for project: " + project.getId() + ": " + e.getMessage(), e);
            }
        }
        return FilterUtils.filterProjects(moduleProjects, moduleSet.getIncludes(), moduleSet.getExcludes(), true, logger);
    }

    @Override
    public void execute(final Assembly assembly, final Archiver archiver, final AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
        Assemblies.forEachModuleSet(assembly, new ModuleSetConsumer(){

            @Override
            public void accept(ModuleSet resolvedModule) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
                ModuleSetAssemblyPhase.this.validate(resolvedModule, configSource);
                Set<MavenProject> moduleProjects = ModuleSetAssemblyPhase.getModuleProjects(resolvedModule, configSource, LOGGER);
                ModuleSources sources = resolvedModule.getSources();
                ModuleSetAssemblyPhase.this.addModuleSourceFileSets(sources, moduleProjects, archiver, configSource);
                ModuleBinaries binaries = resolvedModule.getBinaries();
                ModuleSetAssemblyPhase.this.addModuleBinaries(assembly, resolvedModule, binaries, moduleProjects, archiver, configSource);
            }
        });
    }

    private void validate(ModuleSet moduleSet, AssemblerConfigurationSource configSource) {
        List<MavenProject> projects;
        if (moduleSet.getSources() == null && moduleSet.getBinaries() == null) {
            LOGGER.warn("Encountered ModuleSet with no sources or binaries specified. Skipping.");
        }
        if (moduleSet.isUseAllReactorProjects() && !moduleSet.isIncludeSubModules()) {
            LOGGER.warn("includeSubModules == false is incompatible with useAllReactorProjects. Ignoring.\n\nTo refactor, remove the <includeSubModules/> flag, and use the <includes/> and <excludes/> sections to fine-tune the modules included.");
        }
        if ((projects = configSource.getReactorProjects()) != null && projects.size() > 1 && projects.indexOf(configSource.getProject()) == 0 && moduleSet.getBinaries() != null) {
            LOGGER.warn("[DEPRECATION] moduleSet/binaries section detected in root-project assembly.\n\nMODULE BINARIES MAY NOT BE AVAILABLE FOR THIS ASSEMBLY!\n\n To refactor, move this assembly into a child project and use the flag <useAllReactorProjects>true</useAllReactorProjects> in each moduleSet.");
        }
        if (moduleSet.getSources() != null) {
            ModuleSources sources = moduleSet.getSources();
            if (this.isDeprecatedModuleSourcesConfigPresent(sources)) {
                LOGGER.warn("[DEPRECATION] Use of <moduleSources/> as a file-set is deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
            } else if (!sources.isUseDefaultExcludes()) {
                LOGGER.warn("[DEPRECATION] Use of directoryMode, fileMode, or useDefaultExcludes elements directly within <moduleSources/> are all deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
            }
        }
    }

    void addModuleBinaries(Assembly assembly, ModuleSet moduleSet, ModuleBinaries binaries, Set<MavenProject> projects, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException, DependencyResolutionException {
        if (binaries == null) {
            return;
        }
        LinkedHashSet<MavenProject> moduleProjects = new LinkedHashSet<MavenProject>();
        MavenProjects.select(projects, "pom", MavenProjects.log(LOGGER), MavenProjects.addTo(moduleProjects));
        String classifier = binaries.getAttachmentClassifier();
        HashMap<MavenProject, Artifact> chosenModuleArtifacts = new HashMap<MavenProject, Artifact>();
        for (MavenProject project : moduleProjects) {
            Artifact artifact;
            if (classifier == null) {
                LOGGER.debug("Processing binary artifact for module project: " + project.getId());
                artifact = project.getArtifact();
            } else {
                LOGGER.debug("Processing binary attachment: " + classifier + " for module project: " + project.getId());
                artifact = MavenProjects.findArtifactByClassifier(project, classifier);
                if (artifact == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find attachment with classifier: " + classifier + " in module project: " + project.getId() + ". Please exclude this module from the module-set.");
                }
            }
            chosenModuleArtifacts.put(project, artifact);
            this.addModuleArtifact(artifact, project, archiver, configSource, binaries);
        }
        List<DependencySet> depSets = ModuleSetAssemblyPhase.getDependencySets(binaries);
        if (depSets != null) {
            Map<DependencySet, Set<Artifact>> dependencySetSetMap = this.dependencyResolver.resolveDependencySets(assembly, moduleSet, configSource, depSets);
            for (DependencySet ds : depSets) {
                ds.setUseProjectArtifact(false);
            }
            List<MavenProject> validateModuleVersions = this.validateModuleVersions(moduleProjects);
            if (!validateModuleVersions.isEmpty()) {
                StringBuilder sb = new StringBuilder().append("The current modules seemed to be having different versions.");
                sb.append(LINE_SEPARATOR);
                for (MavenProject mavenProject : validateModuleVersions) {
                    sb.append(" --> ");
                    sb.append(mavenProject.getId());
                    sb.append(LINE_SEPARATOR);
                }
                LOGGER.warn(sb.toString());
            }
            for (MavenProject moduleProject : moduleProjects) {
                LOGGER.debug("Processing binary dependencies for module project: " + moduleProject.getId());
                for (Map.Entry<DependencySet, Set<Artifact>> dependencySetSetEntry : dependencySetSetMap.entrySet()) {
                    AddDependencySetsTask task = new AddDependencySetsTask(Collections.singletonList(dependencySetSetEntry.getKey()), dependencySetSetEntry.getValue(), moduleProject, this.projectBuilder);
                    task.setModuleProject(moduleProject);
                    task.setModuleArtifact((Artifact)chosenModuleArtifacts.get(moduleProject));
                    task.setDefaultOutputDirectory(binaries.getOutputDirectory());
                    task.setDefaultOutputFileNameMapping(binaries.getOutputFileNameMapping());
                    task.execute(archiver, configSource);
                }
            }
        }
    }

    private List<MavenProject> validateModuleVersions(Set<MavenProject> moduleProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        if (moduleProjects != null && !moduleProjects.isEmpty()) {
            String version = moduleProjects.iterator().next().getVersion();
            LOGGER.debug("First version:" + version);
            for (MavenProject mavenProject : moduleProjects) {
                LOGGER.debug(" -> checking " + mavenProject.getId());
                if (version.equals(mavenProject.getVersion())) continue;
                result.add(mavenProject);
            }
        }
        return result;
    }

    void addModuleArtifact(Artifact artifact, MavenProject project, Archiver archiver, AssemblerConfigurationSource configSource, ModuleBinaries binaries) throws ArchiveCreationException, AssemblyFormattingException {
        int fileMode;
        if (artifact.getFile() == null) {
            throw new ArchiveCreationException("Artifact: " + artifact.getId() + " (included by module) does not have an artifact with a file. Please ensure the package phase is run before the assembly is generated.");
        }
        AddArtifactTask task = new AddArtifactTask(artifact, null);
        task.setFileNameMapping(binaries.getOutputFileNameMapping());
        task.setOutputDirectory(binaries.getOutputDirectory());
        task.setProject(project);
        task.setModuleProject(project);
        task.setModuleArtifact(artifact);
        int dirMode = TypeConversionUtils.modeToInt(binaries.getDirectoryMode(), LOGGER);
        if (dirMode != -1) {
            task.setDirectoryMode(dirMode);
        }
        if ((fileMode = TypeConversionUtils.modeToInt(binaries.getFileMode(), LOGGER)) != -1) {
            task.setFileMode(fileMode);
        }
        task.setUnpack(binaries.isUnpack());
        if (binaries.isUnpack() && binaries.getUnpackOptions() != null) {
            task.setIncludes(binaries.getUnpackOptions().getIncludes());
            task.setExcludes(binaries.getUnpackOptions().getExcludes());
        }
        task.execute(archiver, configSource);
    }

    void addModuleSourceFileSets(ModuleSources sources, Set<MavenProject> moduleProjects, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileSet> subFileSets;
        if (sources == null) {
            return;
        }
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        if (this.isDeprecatedModuleSourcesConfigPresent(sources)) {
            FileSet fs = new FileSet();
            fs.setOutputDirectory(sources.getOutputDirectory());
            fs.setIncludes(sources.getIncludes());
            fs.setExcludes(sources.getExcludes());
            fs.setUseDefaultExcludes(sources.isUseDefaultExcludes());
            fileSets.add(fs);
        }
        if ((subFileSets = sources.getFileSets()) == null || subFileSets.isEmpty()) {
            FileSet fs = new FileSet();
            fs.setDirectory("src");
            subFileSets = Collections.singletonList(fs);
        }
        fileSets.addAll(subFileSets);
        for (MavenProject moduleProject : moduleProjects) {
            LOGGER.info("Processing sources for module project: " + moduleProject.getId());
            ArrayList<FileSet> moduleFileSets = new ArrayList<FileSet>();
            for (FileSet fileSet : fileSets) {
                moduleFileSets.add(this.createFileSet(fileSet, sources, moduleProject, configSource));
            }
            AddFileSetsTask task = new AddFileSetsTask(moduleFileSets);
            task.setProject(moduleProject);
            task.setModuleProject(moduleProject);
            task.execute(archiver, configSource);
        }
    }

    boolean isDeprecatedModuleSourcesConfigPresent(ModuleSources sources) {
        boolean result = false;
        if (sources.getOutputDirectory() != null) {
            result = true;
        } else if (sources.getIncludes() != null && !sources.getIncludes().isEmpty()) {
            result = true;
        } else if (sources.getExcludes() != null && !sources.getExcludes().isEmpty()) {
            result = true;
        }
        return result;
    }

    FileSet createFileSet(FileSet fileSet, ModuleSources sources, MavenProject moduleProject, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        String destPath;
        FileSet fs = new FileSet();
        String sourcePath = fileSet.getDirectory();
        File moduleBasedir = moduleProject.getBasedir();
        if (sourcePath != null) {
            File sourceDir = new File(sourcePath);
            if (!AssemblyFileUtils.isAbsolutePath(sourceDir)) {
                sourcePath = new File(moduleBasedir, sourcePath).getAbsolutePath();
            }
        } else {
            sourcePath = moduleBasedir.getAbsolutePath();
        }
        fs.setDirectory(sourcePath);
        fs.setDirectoryMode(fileSet.getDirectoryMode());
        ArrayList<String> excludes = new ArrayList<String>();
        List<String> originalExcludes = fileSet.getExcludes();
        if (originalExcludes != null && !originalExcludes.isEmpty()) {
            excludes.addAll(originalExcludes);
        }
        if (sources.isExcludeSubModuleDirectories()) {
            List modules = moduleProject.getModules();
            for (String moduleSubPath : modules) {
                excludes.add(moduleSubPath + "/**");
            }
        }
        fs.setExcludes(excludes);
        fs.setFiltered(fileSet.isFiltered());
        fs.setFileMode(fileSet.getFileMode());
        fs.setIncludes(fileSet.getIncludes());
        fs.setLineEnding(fileSet.getLineEnding());
        FixedStringSearchInterpolator moduleProjectInterpolator = AssemblyFormatUtils.moduleProjectInterpolator(moduleProject);
        FixedStringSearchInterpolator artifactProjectInterpolator = AssemblyFormatUtils.artifactProjectInterpolator(moduleProject);
        String destPathPrefix = "";
        if (sources.isIncludeModuleDirectory() && !(destPathPrefix = AssemblyFormatUtils.evaluateFileNameMapping(sources.getOutputDirectoryMapping(), moduleProject.getArtifact(), configSource.getProject(), moduleProject.getArtifact(), configSource, moduleProjectInterpolator, artifactProjectInterpolator)).endsWith("/")) {
            destPathPrefix = destPathPrefix + "/";
        }
        destPath = (destPath = fileSet.getOutputDirectory()) == null ? destPathPrefix : destPathPrefix + destPath;
        destPath = AssemblyFormatUtils.getOutputDirectory(destPath, configSource.getFinalName(), configSource, moduleProjectInterpolator, artifactProjectInterpolator);
        fs.setOutputDirectory(destPath);
        LOGGER.debug("module source directory is: " + sourcePath);
        LOGGER.debug("module dest directory is: " + destPath + " (assembly basedir may be prepended)");
        return fs;
    }

    @Override
    public int order() {
        return 30;
    }
}

