/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.attributes.UserGroupModeFileAttributes;
import org.codehaus.plexus.util.FileUtils;

public final class PlexusIoResourceAttributeUtils {
    private PlexusIoResourceAttributeUtils() {
    }

    public static PlexusIoResourceAttributes mergeAttributes(PlexusIoResourceAttributes override, PlexusIoResourceAttributes base, PlexusIoResourceAttributes def) {
        int mode;
        String gname;
        Integer gid;
        String uname;
        Integer uid;
        if (override == null) {
            return base;
        }
        if (base == null) {
            return new SimpleResourceAttributes(override.getUserId() != null && override.getUserId() != -1 ? override.getUserId() : (def != null && def.getUserId() != null && def.getUserId() != -1 ? def.getUserId() : null), override.getUserName() != null ? override.getUserName() : (def != null ? def.getUserName() : null), override.getGroupId() != null && override.getGroupId() != -1 ? override.getGroupId() : (def != null && def.getGroupId() != null && def.getGroupId() != -1 ? def.getGroupId() : null), override.getGroupName() != null ? override.getGroupName() : (def != null ? def.getGroupName() : null), override.getOctalMode());
        }
        Integer n = override.getUserId() != null && override.getUserId() != -1 ? override.getUserId() : (base.getUserId() != null && base.getUserId() != -1 ? base.getUserId() : (uid = def.getUserId() != null && def.getUserId() != -1 ? def.getUserId() : null));
        String string = override.getUserName() != null ? override.getUserName() : (uname = base.getUserName() != null ? base.getUserName() : def.getUserName());
        Integer n2 = override.getGroupId() != null && override.getGroupId() != -1 ? override.getGroupId() : (base.getGroupId() != null && base.getGroupId() != -1 ? base.getGroupId() : (gid = def.getGroupId() != null && def.getGroupId() != -1 ? def.getGroupId() : null));
        String string2 = override.getGroupName() != null ? override.getGroupName() : (gname = base.getGroupName() != null ? base.getGroupName() : def.getGroupName());
        int n3 = override.getOctalMode() > 0 ? override.getOctalMode() : (mode = base.getOctalMode() >= 0 ? base.getOctalMode() : def.getOctalMode());
        if (base instanceof FileAttributes) {
            return new UserGroupModeFileAttributes(uid, uname, gid, gname, mode, (FileAttributes)base);
        }
        return new SimpleResourceAttributes(uid, uname, gid, gname, mode, base.isSymbolicLink());
    }

    public static boolean isGroupExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 8);
    }

    public static boolean isGroupReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 32);
    }

    public static boolean isGroupWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 16);
    }

    public static boolean isOwnerExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 64);
    }

    public static boolean isOwnerReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 256);
    }

    public static boolean isOwnerWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 128);
    }

    public static boolean isWorldExecutableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 1);
    }

    public static boolean isWorldReadableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 4);
    }

    public static boolean isWorldWritableInOctal(int mode) {
        return PlexusIoResourceAttributeUtils.isOctalModeEnabled(mode, 2);
    }

    public static boolean isOctalModeEnabled(int mode, int targetMode) {
        return (mode & targetMode) != 0;
    }

    public static PlexusIoResourceAttributes getFileAttributes(File file) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributes(file, false);
    }

    public static PlexusIoResourceAttributes getFileAttributes(File file, boolean followLinks) throws IOException {
        Map<String, PlexusIoResourceAttributes> byPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(file, false, followLinks);
        PlexusIoResourceAttributes o = byPath.get(file.getAbsolutePath());
        if (o == null) {
            return SimpleResourceAttributes.lastResortDummyAttributesForBrokenOS();
        }
        return o;
    }

    public static Map<String, PlexusIoResourceAttributes> getFileAttributesByPath(File dir) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributesByPath(dir, true);
    }

    @Nonnull
    public static Map<String, PlexusIoResourceAttributes> getFileAttributesByPath(@Nonnull File dir, boolean recursive) throws IOException {
        return PlexusIoResourceAttributeUtils.getFileAttributesByPath(dir, recursive, false);
    }

    @Nonnull
    public static Map<String, PlexusIoResourceAttributes> getFileAttributesByPath(@Nonnull File dir, boolean recursive, boolean followLinks) throws IOException {
        List fileAndDirectoryNames = recursive && dir.isDirectory() ? FileUtils.getFileAndDirectoryNames((File)dir, null, null, (boolean)true, (boolean)true, (boolean)true, (boolean)true) : Collections.singletonList(dir.getAbsolutePath());
        LinkedHashMap<String, PlexusIoResourceAttributes> attributesByPath = new LinkedHashMap<String, PlexusIoResourceAttributes>();
        for (String fileAndDirectoryName : fileAndDirectoryNames) {
            attributesByPath.put(fileAndDirectoryName, new FileAttributes(new File(fileAndDirectoryName), followLinks));
        }
        return attributesByPath;
    }
}

