/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.spi.subsystem.repository.RepositoryFactory;
import org.sonatype.nexus.client.core.subsystem.repository.ProxyRepository;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyProxyRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;

@Named
@Singleton
public class JerseyProxyRepositoryFactory
implements RepositoryFactory<ProxyRepository> {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = 0;
        if (resource instanceof RepositoryProxyResource) {
            ++score;
        }
        if ("proxy".equals(resource.getRepoType())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyProxyRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyProxyRepository(nexusClient, (RepositoryProxyResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return ProxyRepository.class.equals(type);
    }

    @Override
    public JerseyProxyRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyProxyRepository(nexusClient, id);
    }
}

