/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public class PermutationsIterator
extends StringIterator {
    private final StringIterator[] aIterators;
    private boolean aInitialized;

    public PermutationsIterator(List<Supplier<StringIterator>> iteratorsSuppliers) {
        this.aIterators = new StringIterator[iteratorsSuppliers.size()];
        for (int i = 0; i < this.aIterators.length; ++i) {
            StringIterator iterator;
            this.aIterators[i] = iterator = iteratorsSuppliers.get(i).get();
        }
        this.aInitialized = false;
    }

    @Override
    public boolean hasNext() {
        return !this.aInitialized || Arrays.stream(this.aIterators).anyMatch(Iterator::hasNext);
    }

    @Override
    public String nextImpl() {
        if (this.aInitialized) {
            for (int i = this.aIterators.length - 1; i >= 0; --i) {
                if (this.aIterators[i].hasNext()) {
                    this.aIterators[i].next();
                    break;
                }
                if (i == 0) {
                    throw new NoSuchElementException("No more unique values");
                }
                this.aIterators[i].reset();
                this.aIterators[i].next();
            }
        } else {
            for (StringIterator iterator : this.aIterators) {
                iterator.next();
            }
            this.aInitialized = true;
        }
        return this.current();
    }

    @Override
    public void reset() {
        this.aInitialized = false;
        for (StringIterator iterator : this.aIterators) {
            iterator.reset();
        }
    }

    @Override
    public String current() {
        return Arrays.stream(this.aIterators).map(StringIterator::current).reduce("", String::concat);
    }
}

