/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/builtins/UnsignedType;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Ljava/lang/String;ILorg/jetbrains/kotlin/name/ClassId;)V", "arrayClassId", "getArrayClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "typeName", "Lorg/jetbrains/kotlin/name/Name;", "getTypeName", "()Lorg/jetbrains/kotlin/name/Name;", "UBYTE", "USHORT", "UINT", "ULONG", "descriptors"})
public final class UnsignedType
extends Enum<UnsignedType> {
    @NotNull
    private final ClassId classId;
    @NotNull
    private final Name typeName;
    @NotNull
    private final ClassId arrayClassId;
    public static final /* enum */ UnsignedType UBYTE;
    public static final /* enum */ UnsignedType USHORT;
    public static final /* enum */ UnsignedType UINT;
    public static final /* enum */ UnsignedType ULONG;
    private static final /* synthetic */ UnsignedType[] $VALUES;

    private UnsignedType(ClassId classId) {
        this.classId = classId;
        Name name = this.classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
        this.typeName = name;
        this.arrayClassId = new ClassId(this.classId.getPackageFqName(), Name.identifier(this.typeName.asString() + "Array"));
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @NotNull
    public final Name getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final ClassId getArrayClassId() {
        return this.arrayClassId;
    }

    public static UnsignedType[] values() {
        return (UnsignedType[])$VALUES.clone();
    }

    public static UnsignedType valueOf(String value2) {
        return Enum.valueOf(UnsignedType.class, value2);
    }

    static {
        ClassId classId = ClassId.fromString("kotlin/UByte");
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"fromString(\"kotlin/UByte\")");
        UBYTE = new UnsignedType(classId);
        ClassId classId2 = ClassId.fromString("kotlin/UShort");
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"fromString(\"kotlin/UShort\")");
        USHORT = new UnsignedType(classId2);
        ClassId classId3 = ClassId.fromString("kotlin/UInt");
        Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"fromString(\"kotlin/UInt\")");
        UINT = new UnsignedType(classId3);
        ClassId classId4 = ClassId.fromString("kotlin/ULong");
        Intrinsics.checkNotNullExpressionValue((Object)classId4, (String)"fromString(\"kotlin/ULong\")");
        ULONG = new UnsignedType(classId4);
        $VALUES = unsignedTypeArray = new UnsignedType[]{UnsignedType.UBYTE, UnsignedType.USHORT, UnsignedType.UINT, UnsignedType.ULONG};
    }
}

