/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConnectorFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    private static final String PROTOCOL_PROVIDER_DEFAULT_PACKAGE = "com.sun.jmx.remote.protocol";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "JMXConnectorFactory");

    private JMXConnectorFactory() {
    }

    public static JMXConnector connect(JMXServiceURL jMXServiceURL) throws IOException {
        return JMXConnectorFactory.connect(jMXServiceURL, null);
    }

    public static JMXConnector connect(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        if (jMXServiceURL == null) {
            throw new NullPointerException("Null JMXServiceURL");
        }
        JMXConnector jMXConnector = JMXConnectorFactory.newJMXConnector(jMXServiceURL, map);
        jMXConnector.connect(map);
        return jMXConnector;
    }

    private static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    private static <K> Map<K, Object> newHashMap(Map<K, ?> map) {
        return new HashMap(map);
    }

    public static JMXConnector newJMXConnector(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        Object object;
        Map<String, Object> map2;
        if (map == null) {
            map2 = JMXConnectorFactory.newHashMap();
        } else {
            EnvHelp.checkAttributes(map);
            map2 = JMXConnectorFactory.newHashMap(map);
        }
        ClassLoader classLoader = JMXConnectorFactory.resolveClassLoader(map2);
        Class<JMXConnectorProvider> clazz = JMXConnectorProvider.class;
        String string = jMXServiceURL.getProtocol();
        JMXServiceURL jMXServiceURL2 = jMXServiceURL;
        JMXConnectorProvider jMXConnectorProvider = JMXConnectorFactory.getProvider(jMXServiceURL2, map2, "ClientProvider", clazz, classLoader);
        IOException iOException = null;
        if (jMXConnectorProvider == null) {
            if (classLoader != null) {
                try {
                    object = JMXConnectorFactory.getConnectorAsService(classLoader, jMXServiceURL2, map2);
                    if (object != null) {
                        return object;
                    }
                }
                catch (JMXProviderException jMXProviderException) {
                    throw jMXProviderException;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            jMXConnectorProvider = JMXConnectorFactory.getProvider(string, PROTOCOL_PROVIDER_DEFAULT_PACKAGE, JMXConnectorFactory.class.getClassLoader(), "ClientProvider", clazz);
        }
        if (jMXConnectorProvider == null) {
            object = new MalformedURLException("Unsupported protocol: " + string);
            if (iOException == null) {
                throw object;
            }
            throw (MalformedURLException)EnvHelp.initCause(object, iOException);
        }
        object = Collections.unmodifiableMap(map2);
        return jMXConnectorProvider.newJMXConnector(jMXServiceURL, (Map<String, ?>)object);
    }

    private static String resolvePkgs(Map<String, ?> map) throws JMXProviderException {
        String string = null;
        if (map != null) {
            string = (String)map.get(PROTOCOL_PROVIDER_PACKAGES);
        }
        if (string == null) {
            string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES);
                }
            });
        }
        if (string == null) {
            return null;
        }
        if (!(string instanceof String)) {
            String string2 = "Value of jmx.remote.protocol.provider.pkgs parameter is not a String: " + string.getClass().getName();
            throw new JMXProviderException(string2);
        }
        String string3 = string;
        if (string3.trim().equals("")) {
            return null;
        }
        if (string3.startsWith("|") || string3.endsWith("|") || string3.indexOf("||") >= 0) {
            String string4 = "Value of jmx.remote.protocol.provider.pkgs contains an empty element: " + string3;
            throw new JMXProviderException(string4);
        }
        return string3;
    }

    static <T> T getProvider(JMXServiceURL jMXServiceURL, Map<String, Object> map, String string, Class<T> clazz, ClassLoader classLoader) throws IOException {
        String string2 = jMXServiceURL.getProtocol();
        String string3 = JMXConnectorFactory.resolvePkgs(map);
        T t = null;
        if (string3 != null) {
            map.put(PROTOCOL_PROVIDER_CLASS_LOADER, classLoader);
            t = JMXConnectorFactory.getProvider(string2, string3, classLoader, string, clazz);
        }
        return t;
    }

    static <T> Iterator<T> getProviderIterator(Class<T> clazz, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        return serviceLoader.iterator();
    }

    private static JMXConnector getConnectorAsService(ClassLoader classLoader, JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        Iterator<JMXConnectorProvider> iterator = JMXConnectorFactory.getProviderIterator(JMXConnectorProvider.class, classLoader);
        IOException iOException = null;
        while (iterator.hasNext()) {
            JMXConnectorProvider jMXConnectorProvider = iterator.next();
            try {
                JMXConnector jMXConnector = jMXConnectorProvider.newJMXConnector(jMXServiceURL, map);
                return jMXConnector;
            }
            catch (JMXProviderException jMXProviderException) {
                throw jMXProviderException;
            }
            catch (Exception exception) {
                if (logger.traceOn()) {
                    logger.trace("getConnectorAsService", "URL[" + jMXServiceURL + "] Service provider exception: " + exception);
                }
                if (exception instanceof MalformedURLException || iOException != null) continue;
                if (exception instanceof IOException) {
                    iOException = (IOException)exception;
                    continue;
                }
                iOException = EnvHelp.initCause(new IOException(exception.getMessage()), exception);
            }
        }
        if (iOException == null) {
            return null;
        }
        throw iOException;
    }

    static <T> T getProvider(String string, String string2, ClassLoader classLoader, String string3, Class<T> clazz) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Class<?> clazz2;
            String string4 = stringTokenizer.nextToken();
            String string5 = string4 + "." + JMXConnectorFactory.protocol2package(string) + "." + string3;
            try {
                clazz2 = Class.forName(string5, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            if (!clazz.isAssignableFrom(clazz2)) {
                String string6 = "Provider class does not implement " + clazz.getName() + ": " + clazz2.getName();
                throw new JMXProviderException(string6);
            }
            Class clazz3 = (Class)Util.cast(clazz2);
            try {
                return clazz3.newInstance();
            }
            catch (Exception exception) {
                String string7 = "Exception when instantiating provider [" + string5 + "]";
                throw new JMXProviderException(string7, exception);
            }
        }
        return null;
    }

    static ClassLoader resolveClassLoader(Map<String, ?> map) {
        ClassLoader classLoader = null;
        if (map != null) {
            try {
                classLoader = (ClassLoader)map.get(PROTOCOL_PROVIDER_CLASS_LOADER);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("The ClassLoader supplied in the environment map using the jmx.remote.protocol.provider.class.loader attribute is not an instance of java.lang.ClassLoader");
            }
        }
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return classLoader;
    }

    private static String protocol2package(String string) {
        return string.replace('+', '.').replace('-', '_');
    }
}

