/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.decoder;

import com.sun.beans.decoder.AccessorElementHandler;
import com.sun.beans.finder.MethodFinder;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyElementHandler
extends AccessorElementHandler {
    static final String GETTER = "get";
    static final String SETTER = "set";
    private Integer index;

    PropertyElementHandler() {
    }

    @Override
    public void addAttribute(String string, String string2) {
        if (string.equals("index")) {
            this.index = Integer.valueOf(string2);
        } else {
            super.addAttribute(string, string2);
        }
    }

    @Override
    protected boolean isArgument() {
        return false;
    }

    @Override
    protected Object getValue(String string) {
        try {
            return PropertyElementHandler.getPropertyValue(this.getContextBean(), string, this.index);
        }
        catch (Exception exception) {
            this.getOwner().handleException(exception);
            return null;
        }
    }

    @Override
    protected void setValue(String string, Object object) {
        try {
            PropertyElementHandler.setPropertyValue(this.getContextBean(), string, this.index, object);
        }
        catch (Exception exception) {
            this.getOwner().handleException(exception);
        }
    }

    private static Object getPropertyValue(Object object, String string, Integer n) throws IllegalAccessException, IntrospectionException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz = object.getClass();
        if (n == null) {
            return PropertyElementHandler.findGetter(clazz, string, new Class[0]).invoke(object, new Object[0]);
        }
        if (clazz.isArray() && string == null) {
            return Array.get(object, n);
        }
        return PropertyElementHandler.findGetter(clazz, string, Integer.TYPE).invoke(object, n);
    }

    private static void setPropertyValue(Object object, String string, Integer n, Object object2) throws IllegalAccessException, IntrospectionException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz;
        Class<?> clazz2 = object.getClass();
        Class<?> clazz3 = clazz = object2 != null ? object2.getClass() : null;
        if (n == null) {
            PropertyElementHandler.findSetter(clazz2, string, clazz).invoke(object, object2);
        } else if (clazz2.isArray() && string == null) {
            Array.set(object, n, object2);
        } else {
            PropertyElementHandler.findSetter(clazz2, string, Integer.TYPE, clazz).invoke(object, n, object2);
        }
    }

    private static Method findGetter(Class<?> clazz, String string, Class<?> ... classArray) throws IntrospectionException, NoSuchMethodException {
        IndexedPropertyDescriptor indexedPropertyDescriptor;
        Method method;
        if (string == null) {
            return MethodFinder.findInstanceMethod(clazz, GETTER, classArray);
        }
        PropertyDescriptor propertyDescriptor = PropertyElementHandler.getProperty(clazz, string);
        if (classArray.length == 0) {
            Method method2 = propertyDescriptor.getReadMethod();
            if (method2 != null) {
                return method2;
            }
        } else if (propertyDescriptor instanceof IndexedPropertyDescriptor && (method = (indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod()) != null) {
            return method;
        }
        throw new IntrospectionException("Could not find getter for the " + string + " property");
    }

    private static Method findSetter(Class<?> clazz, String string, Class<?> ... classArray) throws IntrospectionException, NoSuchMethodException {
        IndexedPropertyDescriptor indexedPropertyDescriptor;
        Method method;
        if (string == null) {
            return MethodFinder.findInstanceMethod(clazz, SETTER, classArray);
        }
        PropertyDescriptor propertyDescriptor = PropertyElementHandler.getProperty(clazz, string);
        if (classArray.length == 1) {
            Method method2 = propertyDescriptor.getWriteMethod();
            if (method2 != null) {
                return method2;
            }
        } else if (propertyDescriptor instanceof IndexedPropertyDescriptor && (method = (indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod()) != null) {
            return method;
        }
        throw new IntrospectionException("Could not find setter for the " + string + " property");
    }

    private static PropertyDescriptor getProperty(Class<?> clazz, String string) throws IntrospectionException {
        for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        throw new IntrospectionException("Could not find the " + string + " property descriptor");
    }
}

