/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;

class JavadocMemberEnter
extends MemberEnter {
    final DocEnv docenv;

    public static JavadocMemberEnter instance0(Context context) {
        MemberEnter memberEnter = (MemberEnter)context.get(memberEnterKey);
        if (memberEnter == null) {
            memberEnter = new JavadocMemberEnter(context);
        }
        return (JavadocMemberEnter)memberEnter;
    }

    public static void preRegister(final Context context) {
        context.put(memberEnterKey, new Context.Factory<MemberEnter>(){

            @Override
            public MemberEnter make() {
                return new JavadocMemberEnter(context);
            }
        });
    }

    protected JavadocMemberEnter(Context context) {
        super(context);
        this.docenv = DocEnv.instance(context);
    }

    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        super.visitMethodDef(jCMethodDecl);
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        if (methodSymbol == null || methodSymbol.kind != 16) {
            return;
        }
        String string = this.env.toplevel.docComments.get(jCMethodDecl);
        Position.LineMap lineMap = this.env.toplevel.lineMap;
        if (methodSymbol.isConstructor()) {
            this.docenv.makeConstructorDoc(methodSymbol, string, jCMethodDecl, lineMap);
        } else if (JavadocMemberEnter.isAnnotationTypeElement(methodSymbol)) {
            this.docenv.makeAnnotationTypeElementDoc(methodSymbol, string, jCMethodDecl, lineMap);
        } else {
            this.docenv.makeMethodDoc(methodSymbol, string, jCMethodDecl, lineMap);
        }
    }

    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        super.visitVarDef(jCVariableDecl);
        if (jCVariableDecl.sym != null && jCVariableDecl.sym.kind == 4 && !JavadocMemberEnter.isParameter(jCVariableDecl.sym)) {
            String string = this.env.toplevel.docComments.get(jCVariableDecl);
            Position.LineMap lineMap = this.env.toplevel.lineMap;
            this.docenv.makeFieldDoc(jCVariableDecl.sym, string, jCVariableDecl, lineMap);
        }
    }

    private static boolean isAnnotationTypeElement(Symbol.MethodSymbol methodSymbol) {
        return ClassDocImpl.isAnnotationType(methodSymbol.enclClass());
    }

    private static boolean isParameter(Symbol.VarSymbol varSymbol) {
        return (varSymbol.flags() & 0x200000000L) != 0L;
    }
}

