/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema;

import com.sun.codemodel.internal.JJavaName;
import com.sun.codemodel.internal.util.JavadocEscapeWriter;
import com.sun.tools.internal.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CClassInfoParent;
import com.sun.tools.internal.xjc.model.CEnumConstant;
import com.sun.tools.internal.xjc.model.CEnumLeafInfo;
import com.sun.tools.internal.xjc.model.CNonElement;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.model.TypeUse;
import com.sun.tools.internal.xjc.model.TypeUseFactory;
import com.sun.tools.internal.xjc.reader.Ring;
import com.sun.tools.internal.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.BindingComponent;
import com.sun.tools.internal.xjc.reader.xmlschema.Messages;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIConversion;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIEnum;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIEnumMember;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.EnumMemberMode;
import com.sun.tools.internal.xjc.util.MimeTypeRange;
import com.sun.xml.internal.bind.DatatypeConverterImpl;
import com.sun.xml.internal.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.internal.xsom.XSAttributeDecl;
import com.sun.xml.internal.xsom.XSComplexType;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSFacet;
import com.sun.xml.internal.xsom.XSListSimpleType;
import com.sun.xml.internal.xsom.XSRestrictionSimpleType;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XSUnionSimpleType;
import com.sun.xml.internal.xsom.XSVariety;
import com.sun.xml.internal.xsom.impl.util.SchemaWriter;
import com.sun.xml.internal.xsom.visitor.XSSimpleTypeFunction;
import com.sun.xml.internal.xsom.visitor.XSVisitor;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.activation.MimeTypeParseException;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleTypeBuilder
extends BindingComponent {
    protected final BGMBuilder builder = Ring.get(BGMBuilder.class);
    private final Model model = Ring.get(Model.class);
    public final Stack<XSComponent> refererStack = new Stack();
    private XSSimpleType initiatingType;
    public static final Map<String, TypeUse> builtinConversions;
    public final XSSimpleTypeFunction<TypeUse> composer = new XSSimpleTypeFunction<TypeUse>(){

        @Override
        public TypeUse listSimpleType(XSListSimpleType xSListSimpleType) {
            XSSimpleType xSSimpleType = xSListSimpleType.getItemType();
            SimpleTypeBuilder.this.refererStack.push(xSSimpleType);
            TypeUse typeUse = TypeUseFactory.makeCollection(SimpleTypeBuilder.this.build(xSListSimpleType.getItemType()));
            SimpleTypeBuilder.this.refererStack.pop();
            return typeUse;
        }

        @Override
        public TypeUse unionSimpleType(XSUnionSimpleType xSUnionSimpleType) {
            boolean bl = false;
            for (int i = 0; i < xSUnionSimpleType.getMemberSize(); ++i) {
                if (xSUnionSimpleType.getMember(i).getVariety() != XSVariety.LIST) continue;
                bl = true;
                break;
            }
            TypeUse typeUse = CBuiltinLeafInfo.STRING;
            if (bl) {
                typeUse = TypeUseFactory.makeCollection(typeUse);
            }
            return typeUse;
        }

        @Override
        public TypeUse restrictionSimpleType(XSRestrictionSimpleType xSRestrictionSimpleType) {
            return SimpleTypeBuilder.this.compose(xSRestrictionSimpleType.getSimpleBaseType());
        }
    };
    private static final Set<String> builtinTypeSafeEnumCapableTypes;
    private static final BigInteger LONG_MIN;
    private static final BigInteger LONG_MAX;
    private static final BigInteger INT_MIN;
    private static final BigInteger INT_MAX;

    public TypeUse build(XSSimpleType xSSimpleType) {
        XSSimpleType xSSimpleType2 = this.initiatingType;
        this.initiatingType = xSSimpleType;
        TypeUse typeUse = this.checkRefererCustomization(xSSimpleType);
        if (typeUse == null) {
            typeUse = this.compose(xSSimpleType);
        }
        this.initiatingType = xSSimpleType2;
        return typeUse;
    }

    public TypeUse buildDef(XSSimpleType xSSimpleType) {
        XSSimpleType xSSimpleType2 = this.initiatingType;
        this.initiatingType = xSSimpleType;
        TypeUse typeUse = xSSimpleType.apply(this.composer);
        this.initiatingType = xSSimpleType2;
        return typeUse;
    }

    private BIConversion getRefererCustomization() {
        BindInfo bindInfo = this.builder.getBindInfo(this.getReferer());
        BIProperty bIProperty = bindInfo.get(BIProperty.class);
        if (bIProperty == null) {
            return null;
        }
        return bIProperty.getConv();
    }

    public XSComponent getReferer() {
        return this.refererStack.peek();
    }

    private TypeUse checkRefererCustomization(XSSimpleType xSSimpleType) {
        Object object;
        XSComponent xSComponent = this.getReferer();
        if (xSComponent instanceof XSElementDecl) {
            object = (XSElementDecl)xSComponent;
            assert (object.getType() == xSSimpleType);
            BindInfo bindInfo = this.builder.getBindInfo(xSComponent);
            BIConversion bIConversion = bindInfo.get(BIConversion.class);
            if (bIConversion != null) {
                bIConversion.markAsAcknowledged();
                return bIConversion.getTypeUse(xSSimpleType);
            }
            this.detectJavaTypeCustomization();
        } else if (xSComponent instanceof XSAttributeDecl) {
            object = (XSAttributeDecl)xSComponent;
            assert (object.getType() == xSSimpleType);
            this.detectJavaTypeCustomization();
        } else if (xSComponent instanceof XSComplexType) {
            object = (XSComplexType)xSComponent;
            assert (object.getBaseType() == xSSimpleType || object.getContentType() == xSSimpleType);
            this.detectJavaTypeCustomization();
        } else if (xSComponent != xSSimpleType) assert (false);
        object = this.getRefererCustomization();
        if (object != null) {
            ((BIConversion)object).markAsAcknowledged();
            return ((BIConversion)object).getTypeUse(xSSimpleType);
        }
        return null;
    }

    private void detectJavaTypeCustomization() {
        BindInfo bindInfo = this.builder.getBindInfo(this.getReferer());
        BIConversion bIConversion = bindInfo.get(BIConversion.class);
        if (bIConversion != null) {
            bIConversion.markAsAcknowledged();
            this.getErrorReporter().error(bIConversion.getLocation(), "SimpleTypeBuilder.UnnestedJavaTypeCustomization", new Object[0]);
        }
    }

    TypeUse compose(XSSimpleType xSSimpleType) {
        TypeUse typeUse = this.find(xSSimpleType);
        if (typeUse != null) {
            return typeUse;
        }
        return xSSimpleType.apply(this.composer);
    }

    private TypeUse find(XSSimpleType xSSimpleType) {
        TypeUse typeUse;
        Object object;
        boolean bl = false;
        BindInfo bindInfo = this.builder.getBindInfo(xSSimpleType);
        BIConversion bIConversion = bindInfo.get(BIConversion.class);
        if (bIConversion != null) {
            bIConversion.markAsAcknowledged();
            return bIConversion.getTypeUse(xSSimpleType);
        }
        BIEnum bIEnum = bindInfo.get(BIEnum.class);
        if (bIEnum != null) {
            bIEnum.markAsAcknowledged();
            if (!bIEnum.isMapped()) {
                bl = true;
            } else {
                if (!SimpleTypeBuilder.canBeMappedToTypeSafeEnum(xSSimpleType)) {
                    this.getErrorReporter().error(bIEnum.getLocation(), "ConversionFinder.CannotBeTypeSafeEnum", new Object[0]);
                    this.getErrorReporter().error(xSSimpleType.getLocator(), "ConversionFinder.CannotBeTypeSafeEnum.Location", new Object[0]);
                    return null;
                }
                return this.bindToTypeSafeEnum((XSRestrictionSimpleType)xSSimpleType, bIEnum.className, bIEnum.javadoc, bIEnum.members, this.getEnumMemberMode().getModeWithEnum(), bIEnum.getLocation());
            }
        }
        if (xSSimpleType.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema") && (object = xSSimpleType.getName()) != null && (typeUse = this.lookupBuiltin((String)object)) != null) {
            return typeUse;
        }
        if (xSSimpleType.getTargetNamespace().equals("http://ws-i.org/profiles/basic/1.1/xsd") && (object = xSSimpleType.getName()) != null && ((String)object).equals("swaRef")) {
            return CBuiltinLeafInfo.STRING.makeAdapted(SwaRefAdapter.class, false);
        }
        if (xSSimpleType.isRestriction() && !bl && this.shouldBeMappedToTypeSafeEnumByDefault((XSRestrictionSimpleType)(object = xSSimpleType.asRestriction())) && (typeUse = this.bindToTypeSafeEnum((XSRestrictionSimpleType)object, null, null, Collections.<String, BIEnumMember>emptyMap(), this.getEnumMemberMode(), null)) != null) {
            return typeUse;
        }
        return this.getClassSelector()._bindToClass(xSSimpleType, false);
    }

    private boolean shouldBeMappedToTypeSafeEnumByDefault(XSRestrictionSimpleType xSRestrictionSimpleType) {
        if (xSRestrictionSimpleType.isLocal()) {
            return false;
        }
        if (xSRestrictionSimpleType.getRedefinedBy() != null) {
            return false;
        }
        List<XSFacet> list = xSRestrictionSimpleType.getDeclaredFacets("enumeration");
        if (list.isEmpty() || list.size() > this.builder.getGlobalBinding().getDefaultEnumMemberSizeCap()) {
            return false;
        }
        if (!SimpleTypeBuilder.canBeMappedToTypeSafeEnum(xSRestrictionSimpleType)) {
            return false;
        }
        for (XSSimpleType xSSimpleType = xSRestrictionSimpleType; xSSimpleType != null; xSSimpleType = xSSimpleType.getSimpleBaseType()) {
            if (!xSSimpleType.isGlobal() || !this.builder.getGlobalBinding().canBeMappedToTypeSafeEnum(xSSimpleType)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeMappedToTypeSafeEnum(XSSimpleType xSSimpleType) {
        do {
            String string;
            if (!"http://www.w3.org/2001/XMLSchema".equals(xSSimpleType.getTargetNamespace()) || (string = xSSimpleType.getName()) == null) continue;
            if (string.equals("anySimpleType")) {
                return false;
            }
            if (string.equals("ID") || string.equals("IDREF")) {
                return false;
            }
            if (!builtinTypeSafeEnumCapableTypes.contains(string)) continue;
            return true;
        } while ((xSSimpleType = xSSimpleType.getSimpleBaseType()) != null);
        return false;
    }

    private TypeUse bindToTypeSafeEnum(XSRestrictionSimpleType xSRestrictionSimpleType, String string, String string2, Map<String, BIEnumMember> map, EnumMemberMode enumMemberMode, Locator locator) {
        if (locator == null) {
            locator = xSRestrictionSimpleType.getLocator();
        }
        if (string == null) {
            if (!xSRestrictionSimpleType.isGlobal()) {
                this.getErrorReporter().error(locator, "ConversionFinder.NoEnumNameAvailable", new Object[0]);
                return CBuiltinLeafInfo.STRING;
            }
            string = xSRestrictionSimpleType.getName();
        }
        string = this.builder.getNameConverter().toClassName(string);
        Object object = new StringWriter();
        Object object2 = new SchemaWriter(new JavadocEscapeWriter((Writer)object));
        xSRestrictionSimpleType.visit((XSVisitor)object2);
        string2 = string2 != null ? string2 + "\n\n" : "";
        string2 = string2 + Messages.format("ClassSelector.JavadocHeading", xSRestrictionSimpleType.getName()) + "\n<p>\n<pre>\n" + ((StringWriter)object).getBuffer() + "</pre>";
        this.refererStack.push(xSRestrictionSimpleType.getSimpleBaseType());
        object = this.build(xSRestrictionSimpleType.getSimpleBaseType());
        this.refererStack.pop();
        if (object.isCollection()) {
            return null;
        }
        object2 = (CNonElement)object.getInfo();
        if (object2 instanceof CClassInfo) {
            return null;
        }
        XSFacet[] xSFacetArray = new XSFacet[1];
        List<CEnumConstant> list = this.buildCEnumConstants(xSRestrictionSimpleType, false, map, xSFacetArray);
        if (list == null || this.checkMemberNameCollision(list) != null) {
            switch (enumMemberMode) {
                case SKIP: {
                    return null;
                }
                case ERROR: {
                    if (list == null) {
                        this.getErrorReporter().error(xSFacetArray[0].getLocator(), "ERR_CANNOT_GENERATE_ENUM_NAME", xSFacetArray[0].getValue());
                    } else {
                        CEnumConstant[] cEnumConstantArray = this.checkMemberNameCollision(list);
                        this.getErrorReporter().error(cEnumConstantArray[0].getLocator(), "ERR_ENUM_MEMBER_NAME_COLLISION", cEnumConstantArray[0].getName());
                        this.getErrorReporter().error(cEnumConstantArray[1].getLocator(), "ERR_ENUM_MEMBER_NAME_COLLISION_RELATED", new Object[0]);
                    }
                    return null;
                }
                case GENERATE: {
                    list = this.buildCEnumConstants(xSRestrictionSimpleType, true, map, null);
                }
            }
        }
        QName qName = null;
        if (xSRestrictionSimpleType.isGlobal()) {
            qName = new QName(xSRestrictionSimpleType.getTargetNamespace(), xSRestrictionSimpleType.getName());
        }
        CClassInfoParent cClassInfoParent = xSRestrictionSimpleType.isGlobal() ? new CClassInfoParent.Package(this.getClassSelector().getPackage(xSRestrictionSimpleType.getTargetNamespace())) : this.getClassSelector().getClassScope();
        CEnumLeafInfo cEnumLeafInfo = new CEnumLeafInfo(this.model, qName, cClassInfoParent, string, (CNonElement)object2, list, xSRestrictionSimpleType, this.builder.getBindInfo(xSRestrictionSimpleType).toCustomizationList(), locator);
        cEnumLeafInfo.javadoc = string2;
        BIConversion.Static static_ = new BIConversion.Static(xSRestrictionSimpleType.getLocator(), cEnumLeafInfo);
        ((BIConversion)static_).markAsAcknowledged();
        this.builder.getOrCreateBindInfo(xSRestrictionSimpleType).addDecl(static_);
        return ((BIConversion)static_).getTypeUse(xSRestrictionSimpleType);
    }

    private List<CEnumConstant> buildCEnumConstants(XSRestrictionSimpleType xSRestrictionSimpleType, boolean bl, Map<String, BIEnumMember> map, XSFacet[] xSFacetArray) {
        ArrayList<CEnumConstant> arrayList = new ArrayList<CEnumConstant>();
        int n = 1;
        for (XSFacet xSFacet : xSRestrictionSimpleType.getDeclaredFacets("enumeration")) {
            String string = null;
            String string2 = null;
            if (bl) {
                string = "VALUE_" + n++;
            } else {
                String string3 = xSFacet.getValue().value;
                BIEnumMember bIEnumMember = map.get(string3);
                if (bIEnumMember == null) {
                    bIEnumMember = this.builder.getBindInfo(xSFacet).get(BIEnumMember.class);
                }
                if (bIEnumMember != null) {
                    string = bIEnumMember.name;
                    string2 = bIEnumMember.javadoc;
                }
                if (string == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < string3.length(); ++i) {
                        char c = string3.charAt(i);
                        if (Character.isJavaIdentifierPart(c)) {
                            stringBuilder.append(c);
                            continue;
                        }
                        stringBuilder.append('_');
                    }
                    string = this.model.getNameConverter().toConstantName(stringBuilder.toString());
                }
            }
            if (!JJavaName.isJavaIdentifier(string)) {
                if (xSFacetArray != null) {
                    xSFacetArray[0] = xSFacet;
                }
                return null;
            }
            arrayList.add(new CEnumConstant(string, string2, xSFacet.getValue().value, xSFacet.getLocator()));
        }
        return arrayList;
    }

    private CEnumConstant[] checkMemberNameCollision(List<CEnumConstant> list) {
        HashMap<String, CEnumConstant> hashMap = new HashMap<String, CEnumConstant>();
        for (CEnumConstant cEnumConstant : list) {
            CEnumConstant cEnumConstant2 = hashMap.put(cEnumConstant.getName(), cEnumConstant);
            if (cEnumConstant2 == null) continue;
            return new CEnumConstant[]{cEnumConstant2, cEnumConstant};
        }
        return null;
    }

    private EnumMemberMode getEnumMemberMode() {
        return this.builder.getGlobalBinding().getEnumMemberMode();
    }

    private TypeUse lookupBuiltin(String string) {
        if (string.equals("integer") || string.equals("long")) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5 = this.readFacet("maxExclusive", -1);
            BigInteger bigInteger6 = this.min(bigInteger5, bigInteger4 = this.readFacet("maxInclusive", 0));
            if (bigInteger6 != null && (bigInteger3 = this.max(bigInteger2 = this.readFacet("minExclusive", 1), bigInteger = this.readFacet("minInclusive", 0))) != null) {
                if (bigInteger3.compareTo(INT_MIN) >= 0 && bigInteger6.compareTo(INT_MAX) <= 0) {
                    string = "int";
                } else if (bigInteger3.compareTo(LONG_MIN) >= 0 && bigInteger6.compareTo(LONG_MAX) <= 0) {
                    string = "long";
                }
            }
        } else {
            if (string.equals("boolean") && this.isRestrictedTo0And1()) {
                return CBuiltinLeafInfo.BOOLEAN_ZERO_OR_ONE;
            }
            if (string.equals("base64Binary")) {
                return this.lookupBinaryTypeBinding();
            }
            if (string.equals("anySimpleType")) {
                if (this.getReferer() instanceof XSAttributeDecl || this.getReferer() instanceof XSSimpleType) {
                    return CBuiltinLeafInfo.STRING;
                }
                return CBuiltinLeafInfo.ANYTYPE;
            }
        }
        return builtinConversions.get(string);
    }

    private TypeUse lookupBinaryTypeBinding() {
        XSComponent xSComponent = this.getReferer();
        String string = xSComponent.getForeignAttribute("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes");
        if (string != null) {
            try {
                List<MimeTypeRange> list = MimeTypeRange.parseRanges(string);
                MimeTypeRange mimeTypeRange = MimeTypeRange.merge(list);
                if (mimeTypeRange.majorType.equals("image")) {
                    return CBuiltinLeafInfo.IMAGE.makeMimeTyped(mimeTypeRange.toMimeType());
                }
                if ((mimeTypeRange.majorType.equals("application") || mimeTypeRange.majorType.equals("text")) && this.isXml(mimeTypeRange.subType)) {
                    return CBuiltinLeafInfo.XML_SOURCE.makeMimeTyped(mimeTypeRange.toMimeType());
                }
                if (mimeTypeRange.majorType.equals("text") && mimeTypeRange.subType.equals("plain")) {
                    return CBuiltinLeafInfo.STRING.makeMimeTyped(mimeTypeRange.toMimeType());
                }
                return CBuiltinLeafInfo.DATA_HANDLER.makeMimeTyped(mimeTypeRange.toMimeType());
            }
            catch (ParseException parseException) {
                this.getErrorReporter().error(xSComponent.getLocator(), Messages.format("ERR_ILLEGAL_EXPECTED_MIME_TYPE", string, parseException.getMessage()), new Object[0]);
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                this.getErrorReporter().error(xSComponent.getLocator(), Messages.format("ERR_ILLEGAL_EXPECTED_MIME_TYPE", string, mimeTypeParseException.getMessage()), new Object[0]);
            }
        }
        return CBuiltinLeafInfo.BASE64_BYTE_ARRAY;
    }

    private boolean isXml(String string) {
        return string.equals("xml") || string.endsWith("+xml");
    }

    private boolean isRestrictedTo0And1() {
        String string;
        Object object;
        XSFacet xSFacet = this.initiatingType.getFacet("pattern");
        if (xSFacet != null && (((String)(object = xSFacet.getValue().value)).equals("0|1") || ((String)object).equals("1|0") || ((String)object).equals("\\d"))) {
            return true;
        }
        object = this.initiatingType.getFacet("enumeration");
        return object != null && ((string = object.getValue().value).equals("0") || string.equals("1"));
    }

    private BigInteger readFacet(String string, int n) {
        XSFacet xSFacet = this.initiatingType.getFacet(string);
        if (xSFacet == null) {
            return null;
        }
        BigInteger bigInteger = DatatypeConverterImpl._parseInteger((CharSequence)xSFacet.getValue().value);
        if (n != 0) {
            bigInteger = bigInteger.add(BigInteger.valueOf(n));
        }
        return bigInteger;
    }

    private BigInteger min(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            return bigInteger2;
        }
        if (bigInteger2 == null) {
            return bigInteger;
        }
        return bigInteger.min(bigInteger2);
    }

    private BigInteger max(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            return bigInteger2;
        }
        if (bigInteger2 == null) {
            return bigInteger;
        }
        return bigInteger.max(bigInteger2);
    }

    static {
        String[] stringArray;
        builtinConversions = new HashMap<String, TypeUse>();
        Object object = new HashSet<String>();
        for (String string : stringArray = new String[]{"string", "boolean", "float", "decimal", "double", "anyURI"}) {
            object.add(string);
        }
        builtinTypeSafeEnumCapableTypes = Collections.unmodifiableSet(object);
        LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
        LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
        INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
        INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
        object = builtinConversions;
        object.put("string", CBuiltinLeafInfo.STRING);
        object.put("anyURI", CBuiltinLeafInfo.STRING);
        object.put("boolean", CBuiltinLeafInfo.BOOLEAN);
        object.put("hexBinary", CBuiltinLeafInfo.HEXBIN_BYTE_ARRAY);
        object.put("float", CBuiltinLeafInfo.FLOAT);
        object.put("decimal", CBuiltinLeafInfo.BIG_DECIMAL);
        object.put("integer", CBuiltinLeafInfo.BIG_INTEGER);
        object.put("long", CBuiltinLeafInfo.LONG);
        object.put("unsignedInt", CBuiltinLeafInfo.LONG);
        object.put("int", CBuiltinLeafInfo.INT);
        object.put("unsignedShort", CBuiltinLeafInfo.INT);
        object.put("short", CBuiltinLeafInfo.SHORT);
        object.put("unsignedByte", CBuiltinLeafInfo.SHORT);
        object.put("byte", CBuiltinLeafInfo.BYTE);
        object.put("double", CBuiltinLeafInfo.DOUBLE);
        object.put("QName", CBuiltinLeafInfo.QNAME);
        object.put("NOTATION", CBuiltinLeafInfo.QNAME);
        object.put("dateTime", CBuiltinLeafInfo.CALENDAR);
        object.put("date", CBuiltinLeafInfo.CALENDAR);
        object.put("time", CBuiltinLeafInfo.CALENDAR);
        object.put("gYearMonth", CBuiltinLeafInfo.CALENDAR);
        object.put("gYear", CBuiltinLeafInfo.CALENDAR);
        object.put("gMonthDay", CBuiltinLeafInfo.CALENDAR);
        object.put("gDay", CBuiltinLeafInfo.CALENDAR);
        object.put("gMonth", CBuiltinLeafInfo.CALENDAR);
        object.put("duration", CBuiltinLeafInfo.DURATION);
        object.put("token", CBuiltinLeafInfo.TOKEN);
        object.put("normalizedString", CBuiltinLeafInfo.NORMALIZED_STRING);
        object.put("ID", CBuiltinLeafInfo.ID);
        object.put("IDREF", CBuiltinLeafInfo.IDREF);
    }
}

