/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.modeler.wsdl;

import com.sun.tools.internal.ws.processor.config.ModelInfo;
import com.sun.tools.internal.ws.processor.config.WSDLModelInfo;
import com.sun.tools.internal.ws.processor.model.ModelException;
import com.sun.tools.internal.ws.processor.model.java.JavaSimpleType;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBMapping;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBModel;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.internal.ws.processor.modeler.wsdl.ClassNameAllocatorImpl;
import com.sun.tools.internal.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.internal.ws.processor.util.ClassNameCollector;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.internal.xjc.api.S2JJAXBModel;
import com.sun.tools.internal.xjc.api.SchemaCompiler;
import com.sun.tools.internal.xjc.api.TypeAndAnnotation;
import com.sun.tools.internal.xjc.api.XJC;
import com.sun.xml.internal.ws.util.localization.LocalizableMessageFactory;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JAXBModelBuilder {
    private JAXBModel jaxbModel;
    private SchemaCompiler schemaCompiler;
    private final LocalizableMessageFactory _messageFactory = new LocalizableMessageFactory("com.sun.tools.internal.ws.resources.model");
    private final ModelInfo _modelInfo;
    private final ProcessorEnvironment _env;
    private final boolean printstacktrace;
    private final ClassNameAllocatorImpl _classNameAllocator;
    private final ConsoleErrorReporter consoleErrorReporter;

    public JAXBModelBuilder(ModelInfo modelInfo, Properties properties, ClassNameCollector classNameCollector, List list) {
        this._modelInfo = modelInfo;
        this._env = modelInfo.getParent().getEnvironment();
        this._classNameAllocator = new ClassNameAllocatorImpl(classNameCollector);
        this.printstacktrace = Boolean.valueOf(properties.getProperty("printStackTrace"));
        this.consoleErrorReporter = new ConsoleErrorReporter(this._env, false);
        this.internalBuildJAXBModel(list);
    }

    private void internalBuildJAXBModel(List list) {
        try {
            this.schemaCompiler = XJC.createSchemaCompiler();
            this.schemaCompiler.setClassNameAllocator(this._classNameAllocator);
            this.schemaCompiler.setErrorListener(this.consoleErrorReporter);
            this.schemaCompiler.setEntityResolver(this._modelInfo.getEntityResolver());
            int n = 1;
            for (Object object : list) {
                String object2 = object.getOwnerDocument().getDocumentURI();
                String string = new String(object2 + "#types?schema" + n++);
                this.schemaCompiler.parseSchema(string, (Element)object);
            }
            Set<InputSource> set = ((WSDLModelInfo)this._modelInfo).getJAXBBindings();
            if (set != null) {
                for (InputSource inputSource : set) {
                    this.schemaCompiler.parseSchema(inputSource);
                }
            }
        }
        catch (Exception exception) {
            throw new ModelException(exception);
        }
    }

    public JAXBType getJAXBType(QName qName) {
        JAXBMapping jAXBMapping = this.jaxbModel.get(qName);
        if (jAXBMapping == null) {
            this.fail("model.schema.elementNotFound", new Object[]{qName});
        }
        JavaSimpleType javaSimpleType = new JavaSimpleType(jAXBMapping.getType());
        JAXBType jAXBType = new JAXBType(qName, javaSimpleType, jAXBMapping, this.jaxbModel);
        return jAXBType;
    }

    public TypeAndAnnotation getElementTypeAndAnn(QName qName) {
        JAXBMapping jAXBMapping = this.jaxbModel.get(qName);
        if (jAXBMapping == null) {
            this.fail("model.schema.elementNotFound", new Object[]{qName});
        }
        return jAXBMapping.getType().getTypeAnn();
    }

    protected void bind() {
        S2JJAXBModel s2JJAXBModel = this.schemaCompiler.bind();
        if (this.consoleErrorReporter.hasError()) {
            throw new ModelException(this.consoleErrorReporter.getException());
        }
        this.jaxbModel = new JAXBModel(s2JJAXBModel);
        this.jaxbModel.setGeneratedClassNames(this._classNameAllocator.getJaxbGeneratedClasses());
    }

    protected SchemaCompiler getJAXBSchemaCompiler() {
        return this.schemaCompiler;
    }

    protected void fail(String string, Object[] objectArray) {
        throw new ModelException(string, objectArray);
    }

    protected void error(String string, Object[] objectArray) {
        this._env.error(this._messageFactory.getMessage(string, objectArray));
    }

    protected void warn(String string, Object[] objectArray) {
        this._env.warn(this._messageFactory.getMessage(string, objectArray));
    }

    protected void inform(String string, Object[] objectArray) {
        this._env.info(this._messageFactory.getMessage(string, objectArray));
    }

    public JAXBModel getJAXBModel() {
        return this.jaxbModel;
    }
}

