/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.HackJavaValue;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaLong;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.Snapshot;
import com.sun.tools.hat.internal.util.Misc;

public class JavaObjectRef
extends JavaThing {
    private long id;

    public JavaObjectRef(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public boolean isHeapAllocated() {
        return true;
    }

    public JavaThing dereference(Snapshot snapshot, JavaField javaField) {
        return this.dereference(snapshot, javaField, true);
    }

    public JavaThing dereference(Snapshot snapshot, JavaField javaField, boolean bl) {
        if (javaField != null && !javaField.hasId()) {
            return new JavaLong(this.id);
        }
        if (this.id == 0L) {
            return snapshot.getNullThing();
        }
        JavaThing javaThing = snapshot.findThing(this.id);
        if (javaThing == null) {
            if (!snapshot.getUnresolvedObjectsOK() && bl) {
                String string = "WARNING:  Failed to resolve object id " + Misc.toHex(this.id);
                if (javaField != null) {
                    string = string + " for field " + javaField.getName() + " (signature " + javaField.getSignature() + ")";
                }
                System.out.println(string);
            }
            javaThing = new HackJavaValue("Unresolved object " + Misc.toHex(this.id), 0);
        }
        return javaThing;
    }

    public int getSize() {
        return 0;
    }

    public String toString() {
        return "Unresolved object " + Misc.toHex(this.id);
    }
}

