/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JExpressionImpl;
import com.sun.codemodel.internal.JFormatter;
import com.sun.codemodel.internal.JGenerable;
import com.sun.codemodel.internal.JType;

public abstract class JOp {
    private JOp() {
    }

    static boolean hasTopOp(JExpression jExpression) {
        return jExpression instanceof UnaryOp || jExpression instanceof BinaryOp;
    }

    public static JExpression minus(JExpression jExpression) {
        return new UnaryOp("-", jExpression);
    }

    public static JExpression not(JExpression jExpression) {
        if (jExpression == JExpr.TRUE) {
            return JExpr.FALSE;
        }
        if (jExpression == JExpr.FALSE) {
            return JExpr.TRUE;
        }
        return new UnaryOp("!", jExpression);
    }

    public static JExpression complement(JExpression jExpression) {
        return new UnaryOp("~", jExpression);
    }

    public static JExpression incr(JExpression jExpression) {
        return new TightUnaryOp(jExpression, "++");
    }

    public static JExpression decr(JExpression jExpression) {
        return new TightUnaryOp(jExpression, "--");
    }

    public static JExpression plus(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("+", jExpression, jExpression2);
    }

    public static JExpression minus(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("-", jExpression, jExpression2);
    }

    public static JExpression mul(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("*", jExpression, jExpression2);
    }

    public static JExpression div(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("/", jExpression, jExpression2);
    }

    public static JExpression mod(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("%", jExpression, jExpression2);
    }

    public static JExpression shl(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("<<", jExpression, jExpression2);
    }

    public static JExpression shr(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp(">>", jExpression, jExpression2);
    }

    public static JExpression shrz(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp(">>>", jExpression, jExpression2);
    }

    public static JExpression band(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("&", jExpression, jExpression2);
    }

    public static JExpression bor(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("|", jExpression, jExpression2);
    }

    public static JExpression cand(JExpression jExpression, JExpression jExpression2) {
        if (jExpression == JExpr.TRUE) {
            return jExpression2;
        }
        if (jExpression2 == JExpr.TRUE) {
            return jExpression;
        }
        if (jExpression == JExpr.FALSE) {
            return jExpression;
        }
        if (jExpression2 == JExpr.FALSE) {
            return jExpression2;
        }
        return new BinaryOp("&&", jExpression, jExpression2);
    }

    public static JExpression cor(JExpression jExpression, JExpression jExpression2) {
        if (jExpression == JExpr.TRUE) {
            return jExpression;
        }
        if (jExpression2 == JExpr.TRUE) {
            return jExpression2;
        }
        if (jExpression == JExpr.FALSE) {
            return jExpression2;
        }
        if (jExpression2 == JExpr.FALSE) {
            return jExpression;
        }
        return new BinaryOp("||", jExpression, jExpression2);
    }

    public static JExpression xor(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("^", jExpression, jExpression2);
    }

    public static JExpression lt(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("<", jExpression, jExpression2);
    }

    public static JExpression lte(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("<=", jExpression, jExpression2);
    }

    public static JExpression gt(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp(">", jExpression, jExpression2);
    }

    public static JExpression gte(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp(">=", jExpression, jExpression2);
    }

    public static JExpression eq(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("==", jExpression, jExpression2);
    }

    public static JExpression ne(JExpression jExpression, JExpression jExpression2) {
        return new BinaryOp("!=", jExpression, jExpression2);
    }

    public static JExpression _instanceof(JExpression jExpression, JType jType) {
        return new BinaryOp("instanceof", jExpression, jType);
    }

    public static JExpression cond(JExpression jExpression, JExpression jExpression2, JExpression jExpression3) {
        return new TernaryOp("?", ":", jExpression, jExpression2, jExpression3);
    }

    private static class TernaryOp
    extends JExpressionImpl {
        String op1;
        String op2;
        JExpression e1;
        JExpression e2;
        JExpression e3;

        TernaryOp(String string, String string2, JExpression jExpression, JExpression jExpression2, JExpression jExpression3) {
            this.e1 = jExpression;
            this.op1 = string;
            this.e2 = jExpression2;
            this.op2 = string2;
            this.e3 = jExpression3;
        }

        public void generate(JFormatter jFormatter) {
            jFormatter.p('(').g(this.e1).p(this.op1).g(this.e2).p(this.op2).g(this.e3).p(')');
        }
    }

    private static class BinaryOp
    extends JExpressionImpl {
        String op;
        JExpression left;
        JGenerable right;

        BinaryOp(String string, JExpression jExpression, JGenerable jGenerable) {
            this.left = jExpression;
            this.op = string;
            this.right = jGenerable;
        }

        public void generate(JFormatter jFormatter) {
            jFormatter.p('(').g(this.left).p(this.op).g(this.right).p(')');
        }
    }

    private static class TightUnaryOp
    extends UnaryOp {
        TightUnaryOp(JExpression jExpression, String string) {
            super(jExpression, string);
        }

        public void generate(JFormatter jFormatter) {
            if (this.opFirst) {
                jFormatter.p(this.op).g(this.e);
            } else {
                jFormatter.g(this.e).p(this.op);
            }
        }
    }

    private static class UnaryOp
    extends JExpressionImpl {
        protected String op;
        protected JExpression e;
        protected boolean opFirst = true;

        UnaryOp(String string, JExpression jExpression) {
            this.op = string;
            this.e = jExpression;
        }

        UnaryOp(JExpression jExpression, String string) {
            this.op = string;
            this.e = jExpression;
            this.opFirst = false;
        }

        public void generate(JFormatter jFormatter) {
            if (this.opFirst) {
                jFormatter.p('(').p(this.op).g(this.e).p(')');
            } else {
                jFormatter.p('(').g(this.e).p(this.op).p(')');
            }
        }
    }
}

