/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JDeclaration;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JGenerable;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JFormatter {
    private HashMap<String, ReferenceList> collectedReferences;
    private HashSet<JClass> importedClasses;
    private Mode mode = Mode.PRINTING;
    private int indentLevel;
    private final String indentSpace;
    private final PrintWriter pw;
    private char lastChar = '\u0000';
    private boolean atBeginningOfLine = true;
    private JPackage javaLang;
    static final char CLOSE_TYPE_ARGS = '\uffff';

    public JFormatter(PrintWriter printWriter, String string) {
        this.pw = printWriter;
        this.indentSpace = string;
        this.collectedReferences = new HashMap();
        this.importedClasses = new HashSet();
    }

    public JFormatter(PrintWriter printWriter) {
        this(printWriter, "    ");
    }

    public JFormatter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public void close() {
        this.pw.close();
    }

    public boolean isPrinting() {
        return this.mode == Mode.PRINTING;
    }

    public JFormatter o() {
        --this.indentLevel;
        return this;
    }

    public JFormatter i() {
        ++this.indentLevel;
        return this;
    }

    private boolean needSpace(char c, char c2) {
        if (c == ']' && c2 == '{') {
            return true;
        }
        if (c == ';') {
            return true;
        }
        if (c == '\uffff') {
            return c2 != '(';
        }
        if (c == ')' && c2 == '{') {
            return true;
        }
        if (c == ',' || c == '=') {
            return true;
        }
        if (c2 == '=') {
            return true;
        }
        if (Character.isDigit(c)) {
            return c2 != '(' && c2 != ')' && c2 != ';' && c2 != ',';
        }
        if (Character.isJavaIdentifierPart(c)) {
            switch (c2) {
                case '+': 
                case '>': 
                case '@': 
                case '{': 
                case '}': {
                    return true;
                }
            }
            return Character.isJavaIdentifierStart(c2);
        }
        if (Character.isJavaIdentifierStart(c2)) {
            switch (c) {
                case ')': 
                case '+': 
                case ']': 
                case '}': {
                    return true;
                }
            }
            return false;
        }
        if (Character.isDigit(c2)) {
            return c != '(';
        }
        return false;
    }

    private void spaceIfNeeded(char c) {
        if (this.atBeginningOfLine) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.pw.print(this.indentSpace);
            }
            this.atBeginningOfLine = false;
        } else if (this.lastChar != '\u0000' && this.needSpace(this.lastChar, c)) {
            this.pw.print(' ');
        }
    }

    public JFormatter p(char c) {
        if (this.mode == Mode.PRINTING) {
            if (c == '\uffff') {
                this.pw.print('>');
            } else {
                this.spaceIfNeeded(c);
                this.pw.print(c);
            }
            this.lastChar = c;
        }
        return this;
    }

    public JFormatter p(String string) {
        if (this.mode == Mode.PRINTING) {
            this.spaceIfNeeded(string.charAt(0));
            this.pw.print(string);
            this.lastChar = string.charAt(string.length() - 1);
        }
        return this;
    }

    public JFormatter t(JType jType) {
        if (jType.isReference()) {
            return this.t((JClass)jType);
        }
        return this.g(jType);
    }

    public JFormatter t(JClass jClass) {
        switch (this.mode) {
            case PRINTING: {
                if (this.importedClasses.contains(jClass)) {
                    this.p(jClass.name());
                    break;
                }
                if (jClass.outer() != null) {
                    this.t(jClass.outer()).p('.').p(jClass.name());
                    break;
                }
                this.p(jClass.fullName());
                break;
            }
            case COLLECTING: {
                String string = jClass.name();
                if (this.collectedReferences.containsKey(string)) {
                    this.collectedReferences.get(string).add(jClass);
                    break;
                }
                ReferenceList referenceList = new ReferenceList();
                referenceList.add(jClass);
                this.collectedReferences.put(string, referenceList);
            }
        }
        return this;
    }

    public JFormatter id(String string) {
        switch (this.mode) {
            case PRINTING: {
                this.p(string);
                break;
            }
            case COLLECTING: {
                if (this.collectedReferences.containsKey(string)) {
                    if (!this.collectedReferences.get(string).getClasses().isEmpty()) {
                        for (JClass jClass : this.collectedReferences.get(string).getClasses()) {
                            if (jClass.outer() == null) continue;
                            this.collectedReferences.get(string).setId(false);
                            return this;
                        }
                    }
                    this.collectedReferences.get(string).setId(true);
                    break;
                }
                ReferenceList referenceList = new ReferenceList();
                referenceList.setId(true);
                this.collectedReferences.put(string, referenceList);
            }
        }
        return this;
    }

    public JFormatter nl() {
        if (this.mode == Mode.PRINTING) {
            this.pw.println();
            this.lastChar = '\u0000';
            this.atBeginningOfLine = true;
        }
        return this;
    }

    public JFormatter g(JGenerable jGenerable) {
        jGenerable.generate(this);
        return this;
    }

    public JFormatter g(Collection<? extends JGenerable> collection) {
        boolean bl = true;
        if (!collection.isEmpty()) {
            for (JGenerable jGenerable : collection) {
                if (!bl) {
                    this.p(',');
                }
                this.g(jGenerable);
                bl = false;
            }
        }
        return this;
    }

    public JFormatter d(JDeclaration jDeclaration) {
        jDeclaration.declare(this);
        return this;
    }

    public JFormatter s(JStatement jStatement) {
        jStatement.state(this);
        return this;
    }

    public JFormatter b(JVar jVar) {
        jVar.bind(this);
        return this;
    }

    void write(JDefinedClass jDefinedClass) {
        this.mode = Mode.COLLECTING;
        this.d(jDefinedClass);
        this.javaLang = jDefinedClass.owner()._package("java.lang");
        for (ReferenceList objectArray2 : this.collectedReferences.values()) {
            if (objectArray2.collisions(jDefinedClass) || objectArray2.isId()) continue;
            assert (objectArray2.getClasses().size() == 1);
            this.importedClasses.add(objectArray2.getClasses().get(0));
        }
        this.importedClasses.add(jDefinedClass);
        this.mode = Mode.PRINTING;
        assert (jDefinedClass.parentContainer().isPackage()) : "this method is only for a pacakge-level class";
        JPackage jPackage = (JPackage)jDefinedClass.parentContainer();
        if (!jPackage.isUnnamed()) {
            this.nl().d(jPackage);
            this.nl();
        }
        Object[] objectArray = this.importedClasses.toArray(new JClass[this.importedClasses.size()]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            if (this.supressImport((JClass)object, jDefinedClass)) continue;
            this.p("import").p(((JType)object).fullName()).p(';').nl();
        }
        this.nl();
        this.d(jDefinedClass);
    }

    private boolean supressImport(JClass jClass, JClass jClass2) {
        if (jClass._package().isUnnamed()) {
            return true;
        }
        String string = jClass._package().name();
        if (string.equals("java.lang")) {
            return true;
        }
        return jClass._package() == jClass2._package() && jClass.outer() == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ReferenceList {
        private final ArrayList<JClass> classes = new ArrayList();
        private boolean id;

        ReferenceList() {
        }

        public boolean collisions(JDefinedClass jDefinedClass) {
            if (this.classes.size() > 1) {
                return true;
            }
            if (this.id && this.classes.size() != 0) {
                return true;
            }
            for (JClass jClass : this.classes) {
                if (jClass._package() == JFormatter.this.javaLang) {
                    Iterator<JDefinedClass> iterator = jDefinedClass._package().classes();
                    while (iterator.hasNext()) {
                        JDefinedClass jDefinedClass2 = iterator.next();
                        if (!jDefinedClass2.name().equals(jClass.name())) continue;
                        return true;
                    }
                }
                if (jClass.outer() == null) continue;
                return true;
            }
            return false;
        }

        public void add(JClass jClass) {
            if (!this.classes.contains(jClass)) {
                this.classes.add(jClass);
            }
        }

        public List<JClass> getClasses() {
            return this.classes;
        }

        public void setId(boolean bl) {
            this.id = bl;
        }

        public boolean isId() {
            return this.id && this.classes.size() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        COLLECTING,
        PRINTING;

    }
}

