/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclEntryImpl
implements AclEntry {
    private Principal user = null;
    private Vector<Permission> permissionSet = new Vector(10, 10);
    private boolean negative = false;

    public AclEntryImpl(Principal principal) {
        this.user = principal;
    }

    public AclEntryImpl() {
    }

    @Override
    public boolean setPrincipal(Principal principal) {
        if (this.user != null) {
            return false;
        }
        this.user = principal;
        return true;
    }

    @Override
    public void setNegativePermissions() {
        this.negative = true;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public boolean addPermission(Permission permission) {
        if (this.permissionSet.contains(permission)) {
            return false;
        }
        this.permissionSet.addElement(permission);
        return true;
    }

    @Override
    public boolean removePermission(Permission permission) {
        return this.permissionSet.removeElement(permission);
    }

    @Override
    public boolean checkPermission(Permission permission) {
        return this.permissionSet.contains(permission);
    }

    @Override
    public Enumeration<Permission> permissions() {
        return this.permissionSet.elements();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        if (this.user instanceof Group) {
            stringBuffer.append("Group.");
        } else {
            stringBuffer.append("User.");
        }
        stringBuffer.append(this.user + "=");
        Enumeration<Permission> enumeration = this.permissions();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            stringBuffer.append(permission);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        return new String(stringBuffer);
    }

    @Override
    public synchronized Object clone() {
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.user);
        aclEntryImpl.permissionSet = (Vector)this.permissionSet.clone();
        aclEntryImpl.negative = this.negative;
        return aclEntryImpl;
    }

    @Override
    public Principal getPrincipal() {
        return this.user;
    }
}

