/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapIntBufferR;
import java.nio.IntBuffer;

class HeapIntBuffer
extends IntBuffer {
    HeapIntBuffer(int n, int n2) {
        super(-1, 0, n2, n, new int[n], 0);
    }

    HeapIntBuffer(int[] nArray, int n, int n2) {
        super(-1, n, n + n2, nArray.length, nArray, 0);
    }

    protected HeapIntBuffer(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, nArray, n5);
    }

    public IntBuffer slice() {
        return new HeapIntBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    public IntBuffer duplicate() {
        return new HeapIntBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public IntBuffer asReadOnlyBuffer() {
        return new HeapIntBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    public int get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    public int get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    public IntBuffer get(int[] nArray, int n, int n2) {
        HeapIntBuffer.checkBounds(n, n2, nArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), nArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public IntBuffer put(int n) {
        this.hb[this.ix((int)this.nextPutIndex())] = n;
        return this;
    }

    public IntBuffer put(int n, int n2) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = n2;
        return this;
    }

    public IntBuffer put(int[] nArray, int n, int n2) {
        HeapIntBuffer.checkBounds(n, n2, nArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(nArray, n, this.hb, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof HeapIntBuffer) {
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapIntBuffer heapIntBuffer = (HeapIntBuffer)intBuffer;
            int n = heapIntBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapIntBuffer.hb, heapIntBuffer.ix(heapIntBuffer.position()), this.hb, this.ix(this.position()), n);
            heapIntBuffer.position(heapIntBuffer.position() + n);
            this.position(this.position() + n);
        } else if (intBuffer.isDirect()) {
            int n = intBuffer.remaining();
            if (n > this.remaining()) {
                throw new BufferOverflowException();
            }
            intBuffer.get(this.hb, this.ix(this.position()), n);
            this.position(this.position() + n);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    public IntBuffer compact() {
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

