/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(byte[] var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int[] var7, boolean var8) throws IOException;

    UNIXProcess(final byte[] byArray, final byte[] byArray2, final int n, final byte[] byArray3, final int n2, final byte[] byArray4, final int[] nArray, final boolean bl) throws IOException {
        final Gate gate = new Gate();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread thread = new Thread("process reaper"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            UNIXProcess.this.pid = UNIXProcess.this.forkAndExec(byArray, byArray2, n, byArray3, n2, byArray4, nArray, bl);
                        }
                        catch (IOException iOException) {
                            gate.setException(iOException);
                            gate.exit();
                            return;
                        }
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                FileDescriptor fileDescriptor;
                                if (nArray[0] == -1) {
                                    UNIXProcess.this.stdin_stream = new ProcessBuilder.NullOutputStream();
                                } else {
                                    fileDescriptor = new FileDescriptor();
                                    fdAccess.set(fileDescriptor, nArray[0]);
                                    UNIXProcess.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(fileDescriptor));
                                }
                                if (nArray[1] == -1) {
                                    UNIXProcess.this.stdout_stream = new ProcessBuilder.NullInputStream();
                                } else {
                                    fileDescriptor = new FileDescriptor();
                                    fdAccess.set(fileDescriptor, nArray[1]);
                                    UNIXProcess.this.stdout_stream = new BufferedInputStream(new FileInputStream(fileDescriptor));
                                }
                                if (nArray[2] == -1) {
                                    UNIXProcess.this.stderr_stream = new ProcessBuilder.NullInputStream();
                                } else {
                                    fileDescriptor = new FileDescriptor();
                                    fdAccess.set(fileDescriptor, nArray[2]);
                                    UNIXProcess.this.stderr_stream = new FileInputStream(fileDescriptor);
                                }
                                return null;
                            }
                        });
                        gate.exit();
                        int n = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                        UNIXProcess uNIXProcess = UNIXProcess.this;
                        synchronized (uNIXProcess) {
                            UNIXProcess.this.hasExited = true;
                            UNIXProcess.this.exitcode = n;
                            UNIXProcess.this.notifyAll();
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                return null;
            }
        });
        gate.waitForExit();
        IOException iOException = gate.getException();
        if (iOException != null) {
            throw new IOException(iOException.toString());
        }
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            if (!this.hasExited) {
                UNIXProcess.destroyProcess(this.pid);
            }
        }
        try {
            this.stdin_stream.close();
            this.stdout_stream.close();
            this.stderr_stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void initIDs();

    static {
        UNIXProcess.initIDs();
    }

    private static class Gate {
        private boolean exited = false;
        private IOException savedException;

        private Gate() {
        }

        synchronized void exit() {
            this.exited = true;
            this.notify();
        }

        synchronized void waitForExit() {
            boolean bl = false;
            while (!this.exited) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }

        void setException(IOException iOException) {
            this.savedException = iOException;
        }

        IOException getException() {
            return this.savedException;
        }
    }
}

