/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap.server;

import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.SOAPDecoder;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.handler.HandlerContext;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.model.JavaMethod;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.streaming.SourceReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPXMLDecoder
extends SOAPDecoder {
    private static final Set<String> requiredRoles = new HashSet<String>();
    private static final QName emptyBodyName = new QName("");

    public SOAPXMLDecoder() {
        requiredRoles.add("http://schemas.xmlsoap.org/soap/actor/next");
        requiredRoles.add("");
    }

    @Override
    public InternalMessage toInternalMessage(SOAPMessage sOAPMessage, MessageInfo messageInfo) {
        InternalMessage internalMessage;
        block6: {
            XMLStreamReader xMLStreamReader = null;
            try {
                InternalMessage internalMessage2 = new InternalMessage();
                this.processAttachments(messageInfo, internalMessage2, sOAPMessage);
                Source source = sOAPMessage.getSOAPPart().getContent();
                xMLStreamReader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(sOAPMessage));
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
                this.decodeEnvelope(xMLStreamReader, internalMessage2, false, messageInfo);
                internalMessage = internalMessage2;
                if (xMLStreamReader == null) break block6;
            }
            catch (Exception exception) {
                try {
                    if (this.isBadXML(exception)) {
                        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
                        HandlerContext handlerContext = runtimeContext.getHandlerContext();
                        this.raiseBadXMLFault(handlerContext);
                    }
                    throw new ServerRtException("soapdecoder.err", new Object[]{exception});
                }
                catch (Throwable throwable) {
                    if (xMLStreamReader != null) {
                        XMLStreamReaderUtil.close(xMLStreamReader);
                    }
                    throw throwable;
                }
            }
            XMLStreamReaderUtil.close(xMLStreamReader);
        }
        return internalMessage;
    }

    protected boolean isBadXML(Exception exception) {
        while (exception != null) {
            if (exception instanceof XMLStreamException) {
                return true;
            }
            exception = exception.getCause() instanceof Exception ? (Exception)exception.getCause() : null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InternalMessage toInternalMessage(SOAPMessage sOAPMessage, InternalMessage internalMessage, MessageInfo messageInfo) {
        XMLStreamReader xMLStreamReader = null;
        try {
            this.processAttachments(messageInfo, internalMessage, sOAPMessage);
            Source source = sOAPMessage.getSOAPPart().getContent();
            xMLStreamReader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(sOAPMessage));
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            this.decodeEnvelope(xMLStreamReader, internalMessage, true, messageInfo);
            this.convertBodyBlock(internalMessage, messageInfo);
            if (xMLStreamReader == null) return internalMessage;
        }
        catch (Exception exception) {
            try {
                if (!this.isBadXML(exception)) throw new ServerRtException("soapdecoder.err", new Object[]{exception});
                RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
                HandlerContext handlerContext = runtimeContext.getHandlerContext();
                this.raiseBadXMLFault(handlerContext);
                throw new ServerRtException("soapdecoder.err", new Object[]{exception});
            }
            catch (Throwable throwable) {
                if (xMLStreamReader == null) throw throwable;
                XMLStreamReaderUtil.close(xMLStreamReader);
                throw throwable;
            }
        }
        XMLStreamReaderUtil.close(xMLStreamReader);
        return internalMessage;
    }

    @Override
    public void decodeDispatchMethod(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        MessageContext messageContext;
        Method method;
        QName qName = xMLStreamReader.getEventType() == 1 ? xMLStreamReader.getName() : emptyBodyName;
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeModel runtimeModel = runtimeContext.getModel();
        JavaMethod javaMethod = runtimeModel.getJavaMethod(qName);
        Method method2 = method = javaMethod == null ? null : javaMethod.getMethod();
        if (method == null) {
            this.raiseFault(this.getSenderFaultCode(), "Cannot find the dispatch method");
        }
        if ((messageContext = MessageInfoUtil.getMessageContext(messageInfo)) != null) {
            String string = runtimeModel.getPortTypeName().getNamespaceURI();
            String string2 = javaMethod.getOperationName();
            MessageContextUtil.setWsdlOperation(messageContext, new QName(string, string2));
        }
        messageInfo.setMethod(method);
    }

    @Override
    protected SOAPFaultInfo decodeFault(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        this.raiseFault(this.getSenderFaultCode(), "Server cannot handle fault message");
        return null;
    }

    @Override
    protected void raiseBadXMLFault(HandlerContext handlerContext) {
        MessageContextUtil.setHttpStatusCode(handlerContext.getMessageContext(), 400);
        this.raiseFault(this.getSenderFaultCode(), "Bad request");
    }

    @Override
    public Set<String> getRequiredRoles() {
        return requiredRoles;
    }

    @Override
    public String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    @Override
    protected QName getSenderFaultCode() {
        return SOAPConstants.FAULT_CODE_CLIENT;
    }

    @Override
    protected QName getReceiverFaultCode() {
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    @Override
    protected QName getVersionMismatchFaultCode() {
        return SOAPConstants.FAULT_CODE_VERSION_MISMATCH;
    }
}

