/* $NetBSD$ */

/*
 * Copyright (c) 2003 Dennis I. Chernoivanov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "paneld.h"

static int	selmenu_next(struct menu *m);
static int	selmenu_prev(struct menu *m);
static int	selmenu_select(struct menu *m);

static int
selmenu_next(struct menu *m)
{
	return E_NEXT;
}

static int
selmenu_prev(struct menu *m)
{
	return E_PREV;
}

/*
 * Select one of the childs for the execution
 */
static int
selmenu_select(struct menu *m)
{
	struct menu *mcur = m->child;
	struct menu *mlast = m->child;

	if ((m == NULL) || (mcur == NULL))
		return E_OK;

	while (mlast->next != NULL)
		mlast = mlast->next;

	if (window->set_title(m->nm) == E_OK) {
		window->set_list(m->child);
		for (;;) {
			int err;

			window->set_focus(mcur);

			switch( (err = enter_menu(m))) {
			case E_OK:
				break;
			case E_NEXT:
				if (mcur->next != NULL)
					mcur = mcur->next;
				else
					mcur = m->child;
				break;
			case E_PREV:
				if (mcur->prev != NULL)
					mcur = mcur->prev;
				else
					mcur = mlast;
				break;
			case E_SELECT:
				return mcur->ops->select(mcur);
			default:
				return err;
			}
		}
	}

	return E_OK;
}

struct menu_ops*
get_select_ops(void)
{
	static struct menu_ops sel_ops = {
		selmenu_next,
		selmenu_prev,
		none_inc,
		none_dec,
		selmenu_select,
		none_allocbuf
	};
	return &sel_ops;
}
