/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class NamePart
extends SystemFunction {
    public static final int NAME = 0;
    public static final int LOCAL_NAME = 1;
    public static final int NAMESPACE_URI = 2;
    public static final int GENERATE_ID = 3;
    public static final int DOCUMENT_URI = 4;
    public static final int NODE_NAME = 6;

    public Expression simplify() throws XPathException {
        this.useContextItemAsDefault();
        return this.simplifyArguments(true);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        NodeInfo nodeInfo = (NodeInfo)this.argument[0].evaluateItem(xPathContext);
        if (nodeInfo == null) {
            if (this.operation == 6) {
                return null;
            }
            return StringValue.EMPTY_STRING;
        }
        switch (this.operation) {
            case 0: {
                string = nodeInfo.getDisplayName();
                break;
            }
            case 1: {
                string = nodeInfo.getLocalPart();
                break;
            }
            case 2: {
                String string2 = nodeInfo.getURI();
                string = string2 == null ? "" : string2;
                break;
            }
            case 3: {
                string = nodeInfo.generateId();
                break;
            }
            case 4: {
                string = nodeInfo.getSystemId();
                break;
            }
            case 6: {
                String string3 = nodeInfo.getLocalPart();
                String string4 = nodeInfo.getURI();
                if (string3 == null || string3.equals("")) {
                    return null;
                }
                return new QNameValue(string4, string3);
            }
            default: {
                throw new UnsupportedOperationException("Unknown name operation");
            }
        }
        return new StringValue(string);
    }
}

