# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TopologyResource(Model):
    """TopologyResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :ivar calculated_date_time: The UTC time on which the topology was
     calculated
    :vartype calculated_date_time: datetime
    :ivar topology_resources: Azure resources which are part of this topology
     resource
    :vartype topology_resources:
     list[~azure.mgmt.security.models.TopologySingleResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'calculated_date_time': {'readonly': True},
        'topology_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'calculated_date_time': {'key': 'properties.calculatedDateTime', 'type': 'iso-8601'},
        'topology_resources': {'key': 'properties.topologyResources', 'type': '[TopologySingleResource]'},
    }

    def __init__(self, **kwargs) -> None:
        super(TopologyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.calculated_date_time = None
        self.topology_resources = None
