# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EncryptionDetails(Model):
    """Details needed if the VM was encrypted at the time of backup.

    :param encryption_enabled: Identifies whether this backup copy represents
     an encrypted VM at the time of backup.
    :type encryption_enabled: bool
    :param kek_url: Key Url.
    :type kek_url: str
    :param secret_key_url: Secret Url.
    :type secret_key_url: str
    :param kek_vault_id: ID of Key Vault where KEK is stored.
    :type kek_vault_id: str
    :param secret_key_vault_id: ID of Key Vault where Secret is stored.
    :type secret_key_vault_id: str
    """

    _attribute_map = {
        'encryption_enabled': {'key': 'encryptionEnabled', 'type': 'bool'},
        'kek_url': {'key': 'kekUrl', 'type': 'str'},
        'secret_key_url': {'key': 'secretKeyUrl', 'type': 'str'},
        'kek_vault_id': {'key': 'kekVaultId', 'type': 'str'},
        'secret_key_vault_id': {'key': 'secretKeyVaultId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EncryptionDetails, self).__init__(**kwargs)
        self.encryption_enabled = kwargs.get('encryption_enabled', None)
        self.kek_url = kwargs.get('kek_url', None)
        self.secret_key_url = kwargs.get('secret_key_url', None)
        self.kek_vault_id = kwargs.get('kek_vault_id', None)
        self.secret_key_vault_id = kwargs.get('secret_key_vault_id', None)
